/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.node;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.io.NumberOutput;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.node.NumericNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class LongNode
extends NumericNode {
    final long _value;

    public LongNode(long v) {
        this._value = v;
    }

    public static LongNode valueOf(long l) {
        return new LongNode(l);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.LONG;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public int intValue() {
        return (int)this._value;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public String asText() {
        return NumberOutput.toString(this._value);
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((LongNode)o)._value == this._value;
    }

    public int hashCode() {
        return (int)this._value ^ (int)(this._value >> 32);
    }
}

