/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.org.apache.commons.codec.binary.Base64;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.NamespaceRemovingInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XpathUtils {
    private static DateUtils dateUtils = new DateUtils();
    private static Log log = LogFactory.getLog(XpathUtils.class);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Document documentFrom(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        is = new NamespaceRemovingInputStream(is);
        Document doc = factory.newDocumentBuilder().parse(is);
        is.close();
        return doc;
    }

    public static Document documentFrom(String xml) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(new ByteArrayInputStream(xml.getBytes()));
    }

    public static Document documentFrom(URL url) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(url.openStream());
    }

    public static Double asDouble(String expression, Node node) throws XPathExpressionException {
        String doubleString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(doubleString) ? null : Double.valueOf(doubleString);
    }

    public static String asString(String expression, Node node) throws XPathExpressionException {
        return XpathUtils.evaluateAsString(expression, node);
    }

    public static Integer asInteger(String expression, Node node) throws XPathExpressionException {
        String intString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(intString) ? null : Integer.valueOf(intString);
    }

    public static Boolean asBoolean(String expression, Node node) throws XPathExpressionException {
        String booleanString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(booleanString) ? null : Boolean.valueOf(booleanString);
    }

    public static Float asFloat(String expression, Node node) throws XPathExpressionException {
        String floatString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(floatString) ? null : Float.valueOf(floatString);
    }

    public static Long asLong(String expression, Node node) throws XPathExpressionException {
        String longString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(longString) ? null : Long.valueOf(longString);
    }

    public static Byte asByte(String expression, Node node) throws XPathExpressionException {
        String byteString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(byteString) ? null : Byte.valueOf(byteString);
    }

    public static Date asDate(String expression, Node node) throws XPathExpressionException {
        String dateString = XpathUtils.evaluateAsString(expression, node);
        if (XpathUtils.isEmptyString(dateString)) {
            return null;
        }
        return dateUtils.parseIso8601Date(dateString);
    }

    public static ByteBuffer asByteBuffer(String expression, Node node) throws XPathExpressionException {
        String base64EncodedString = XpathUtils.evaluateAsString(expression, node);
        if (XpathUtils.isEmptyString(base64EncodedString)) {
            return null;
        }
        if (!XpathUtils.isEmpty(node)) {
            try {
                byte[] base64EncodedBytes = base64EncodedString.getBytes("UTF-8");
                byte[] decodedBytes = Base64.decodeBase64(base64EncodedBytes);
                return ByteBuffer.wrap(decodedBytes);
            }
            catch (UnsupportedEncodingException e) {
                throw new AmazonClientException("Unable to unmarshall XML data into a ByteBuffer", e);
            }
        }
        return null;
    }

    public static boolean isEmpty(Node node) {
        return node == null;
    }

    public static int nodeLength(NodeList list) {
        return list == null ? 0 : list.getLength();
    }

    private static String evaluateAsString(String expression, Node node) throws XPathExpressionException {
        if (XpathUtils.isEmpty(node)) {
            return null;
        }
        String s = XpathUtils.evaluateXPath(node, expression);
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static Node asNode(String nodeName, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return XpathUtils.findXPathNode(node, nodeName);
    }

    public static NodeList asNodeList(String nodeName, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return XpathUtils.findXPathNodeList(node, nodeName);
    }

    private static boolean isEmptyString(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    private static String evaluateXPath(Node node, String xPath) {
        int currentSearchIndex = 0;
        while (currentSearchIndex < xPath.length()) {
            int endingIndex = xPath.indexOf("/", currentSearchIndex);
            String noderNameFromXPath = null;
            noderNameFromXPath = endingIndex == -1 ? xPath.substring(currentSearchIndex) : xPath.substring(currentSearchIndex, endingIndex);
            node = XpathUtils.findChildNodeWithName(node, noderNameFromXPath);
            if (endingIndex == -1) break;
            currentSearchIndex = endingIndex + 1;
        }
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private static Node findXPathNode(Node node, String xPath) {
        int currentSearchIndex = 0;
        while (currentSearchIndex < xPath.length()) {
            int endingIndex = xPath.indexOf("/", currentSearchIndex);
            String noderNameFromXPath = null;
            noderNameFromXPath = endingIndex == -1 ? xPath.substring(currentSearchIndex) : xPath.substring(currentSearchIndex, endingIndex);
            node = XpathUtils.findChildNodeWithName(node, noderNameFromXPath);
            if (endingIndex == -1) break;
            currentSearchIndex = endingIndex + 1;
        }
        return node;
    }

    private static NodeList findXPathNodeList(Node node, String xPath) {
        int currentSearchIndex = 0;
        while (currentSearchIndex < xPath.length()) {
            int endingIndex = xPath.indexOf("/", currentSearchIndex);
            String noderNameFromXPath = null;
            noderNameFromXPath = endingIndex == -1 ? xPath.substring(currentSearchIndex) : xPath.substring(currentSearchIndex, endingIndex);
            node = XpathUtils.findChildNodeWithName(node, noderNameFromXPath);
            if (endingIndex == -1) break;
            currentSearchIndex = endingIndex + 1;
        }
        return node.getChildNodes();
    }

    private static Node findChildNodeWithName(Node node, String childName) {
        if (node == null) {
            return null;
        }
        if (node.getNodeName().equals(childName)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(childName)) continue;
            return nodeList.item(i);
        }
        return null;
    }
}

