/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream;

import com.amazonaws.javax.xml.namespace.NamespaceContext;
import com.amazonaws.javax.xml.stream.Entity;
import com.amazonaws.javax.xml.stream.Location;
import com.amazonaws.javax.xml.stream.PropertyManager;
import com.amazonaws.javax.xml.stream.StaxErrorReporter;
import com.amazonaws.javax.xml.stream.XMLDTDScannerImpl;
import com.amazonaws.javax.xml.stream.XMLEntityManager;
import com.amazonaws.javax.xml.stream.XMLEntityReaderImpl;
import com.amazonaws.javax.xml.stream.XMLEntityStorage;
import com.amazonaws.javax.xml.stream.XMLNSDocumentScannerImpl;
import com.amazonaws.javax.xml.stream.XMLStreamException;
import com.amazonaws.javax.xml.stream.XMLStreamException2;
import com.amazonaws.javax.xml.stream.XMLStreamReader;
import com.amazonaws.javax.xml.stream.dtd.nonvalidating.DTDGrammar;
import com.amazonaws.javax.xml.stream.dtd.nonvalidating.XMLNotationDecl;
import com.amazonaws.javax.xml.stream.events.EntityDeclarationImpl;
import com.amazonaws.javax.xml.stream.events.NotationDeclarationImpl;
import com.amazonaws.javax.xml.stream.xerces.util.NamespaceContextWrapper;
import com.amazonaws.javax.xml.stream.xerces.util.SymbolTable;
import com.amazonaws.javax.xml.stream.xerces.util.XMLStringBuffer;
import com.amazonaws.javax.xml.stream.xerces.xni.QName;
import com.amazonaws.javax.xml.stream.xerces.xni.XNIException;
import com.amazonaws.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class XMLReaderImpl
implements XMLStreamReader {
    private SymbolTable fSymbolTable = new SymbolTable();
    protected XMLNSDocumentScannerImpl fScanner = new XMLNSDocumentScannerImpl();
    protected NamespaceContextWrapper fNamespaceContextWrapper = new NamespaceContextWrapper(this.fScanner.getNamespaceContext());
    protected XMLEntityManager fEntityManager = new XMLEntityManager();
    protected StaxErrorReporter fErrorReporter = new StaxErrorReporter();
    protected XMLEntityReaderImpl fEntityScanner = null;
    protected XMLInputSource fInputSource = null;
    protected PropertyManager fPropertyManager = null;
    private int fEventType;
    private boolean fReuse = true;
    private boolean fBindNamespaces = true;
    private String fDTDDecl = null;

    public XMLReaderImpl(XMLInputSource inputSource, PropertyManager props) throws XMLStreamException {
        this.init(props);
        this.setInputSource(inputSource);
    }

    public void setInputSource(XMLInputSource inputSource) throws XMLStreamException {
        this.fReuse = false;
        try {
            this.fScanner.setInputSource(inputSource);
            this.fEventType = this.fScanner.next();
        }
        catch (IOException ex) {
            throw new XMLStreamException2(ex);
        }
        catch (XNIException ex) {
            throw new XMLStreamException2(ex.getMessage(), this.getLocation(), ex.getException());
        }
    }

    void init(PropertyManager propertyManager) throws XMLStreamException {
        this.fPropertyManager = propertyManager;
        propertyManager.setProperty("http://apache.org/xml/properties/internal/symbol-table", this.fSymbolTable);
        propertyManager.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.fErrorReporter);
        propertyManager.setProperty("http://apache.org/xml/properties/internal/entity-manager", this.fEntityManager);
        this.reset();
    }

    public boolean canReuse() {
        return this.fReuse;
    }

    public void reset() {
        this.fReuse = true;
        this.fEventType = 0;
        this.fEntityManager.reset(this.fPropertyManager);
        this.fScanner.reset(this.fPropertyManager);
        this.fDTDDecl = null;
        this.fEntityScanner = (XMLEntityReaderImpl)this.fEntityManager.getEntityReader();
        this.fBindNamespaces = (Boolean)this.fPropertyManager.getProperty("com.amazonaws.javax.xml.stream.isNamespaceAware");
    }

    public void close() throws XMLStreamException {
        this.fReuse = true;
    }

    public String getCharacterEncodingScheme() {
        return this.fScanner.getCharacterEncodingScheme();
    }

    public String getEncoding() {
        return this.fEntityScanner.getEncoding();
    }

    public int getEventType() {
        return this.fEventType;
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 9) {
            return this.fScanner.getEntityName();
        }
        throw new IllegalStateException("Method getLocalName() cannot be called for " + XMLReaderImpl.getEventTypeString(this.fEventType) + " event.");
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().uri;
        }
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLReaderImpl.getEventTypeString(this.fEventType) + " But expected state is " + XMLReaderImpl.getEventTypeString(3));
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLReaderImpl.getEventTypeString(this.fEventType) + " But expected state is " + XMLReaderImpl.getEventTypeString(3));
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            String string = this.fScanner.getElementQName().prefix;
            return string == null ? "" : string;
        }
        return null;
    }

    public String getVersion() {
        return this.fEntityScanner.getVersion();
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.fEventType == -1) {
            return false;
        }
        return this.fEventType != 8;
    }

    public boolean isStandalone() {
        return this.fScanner.isStandAlone();
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            if (this.fEventType != -1) {
                throw new NoSuchElementException("END_DOCUMENT reached: no more elements on the stream.");
            }
            throw new XMLStreamException("Error processing input source. The input stream is not complete.");
        }
        try {
            this.fEventType = this.fScanner.next();
            return this.fEventType;
        }
        catch (IOException iOException) {
            Boolean bl;
            if (this.fScanner.fScannerState == 46 && (bl = (Boolean)this.fPropertyManager.getProperty("com.amazonaws.javax.xml.stream.isValidating")) != null && !bl.booleanValue()) {
                this.fEventType = 11;
                this.fScanner.setScannerState(43);
                this.fScanner.setDriver(this.fScanner.fPrologDriver);
                if (this.fDTDDecl == null || this.fDTDDecl.length() == 0) {
                    this.fDTDDecl = "<!-- Exception scanning External DTD Subset.  True contents of DTD cannot be determined.  Processing will continue as XMLInputFactory.IS_VALIDATING == false. -->";
                }
                return 11;
            }
            throw new XMLStreamException2(iOException.getMessage(), this.getLocation(), iOException);
        }
        catch (XNIException xNIException) {
            throw new XMLStreamException2(xNIException.getMessage(), this.getLocation(), xNIException.getException());
        }
    }

    static final String getEventTypeString(int n) {
        switch (n) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + String.valueOf(n);
    }

    public int getAttributeCount() {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLength();
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeCount()");
    }

    public com.amazonaws.javax.xml.namespace.QName getAttributeName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getAttributeIterator().getQualifiedName(n));
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeName()");
    }

    public String getAttributeType(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getType(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeType()");
    }

    public String getAttributeValue(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public Location getLocation() {
        return new Location(){
            String _systemId;
            String _publicId;
            int _offset;
            int _columnNumber;
            int _lineNumber;
            {
                this._systemId = XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
                this._publicId = XMLReaderImpl.this.fEntityScanner.getPublicId();
                this._offset = XMLReaderImpl.this.fEntityScanner.getCharacterOffset();
                this._columnNumber = XMLReaderImpl.this.fEntityScanner.getColumnNumber();
                this._lineNumber = XMLReaderImpl.this.fEntityScanner.getLineNumber();
            }

            public String getLocationURI() {
                return this._systemId;
            }

            public int getCharacterOffset() {
                return this._offset;
            }

            public int getColumnNumber() {
                return this._columnNumber;
            }

            public int getLineNumber() {
                return this._lineNumber;
            }

            public String getPublicId() {
                return this._publicId;
            }

            public String getSystemId() {
                return this._systemId;
            }

            public String toString() {
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append("Line number = " + this.getLineNumber());
                sbuffer.append("\n");
                sbuffer.append("Column number = " + this.getColumnNumber());
                sbuffer.append("\n");
                sbuffer.append("System Id = " + this.getSystemId());
                sbuffer.append("\n");
                sbuffer.append("Public Id = " + this.getPublicId());
                sbuffer.append("\n");
                sbuffer.append("Location Uri= " + this.getLocationURI());
                sbuffer.append("\n");
                sbuffer.append("CharacterOffset = " + this.getCharacterOffset());
                sbuffer.append("\n");
                return sbuffer.toString();
            }
        };
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContextWrapper;
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getDeclaredPrefixCount();
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespaceCount().");
    }

    public String getNamespacePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            String string = this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n);
            return string.equals("") ? null : string;
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespacePrefix().");
    }

    public String getNamespaceURI(int n) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getURI(this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n));
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLReaderImpl.getEventTypeString(1) + ", " + XMLReaderImpl.getEventTypeString(2) + ", " + XMLReaderImpl.getEventTypeString(13) + " valid for getNamespaceURI().");
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.fPropertyManager != null) {
            if (string.equals("com.amazonaws.javax.xml.stream.notations")) {
                return this.getNotationDecls();
            }
            if (string.equals("com.amazonaws.javax.xml.stream.entities")) {
                return this.getEntityDecls();
            }
            return this.fPropertyManager.getProperty(string);
        }
        return null;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().toString();
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return this.fScanner.getCharacterData().toString();
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
                Entity entity = (Entity)hashtable.get(string);
                if (entity == null) {
                    return null;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId();
                }
                return ((Entity.InternalEntity)entity).text;
            }
            return null;
        }
        if (this.fEventType == 11) {
            if (this.fDTDDecl != null) {
                return this.fDTDDecl;
            }
            XMLStringBuffer xMLStringBuffer = this.fScanner.getDTDDecl();
            this.fDTDDecl = xMLStringBuffer.toString();
            return this.fDTDDecl;
        }
        throw new IllegalStateException("Current state " + XMLReaderImpl.getEventTypeString(this.fEventType) + " is not among the states" + XMLReaderImpl.getEventTypeString(4) + ", " + XMLReaderImpl.getEventTypeString(5) + ", " + XMLReaderImpl.getEventTypeString(12) + ", " + XMLReaderImpl.getEventTypeString(6) + ", " + XMLReaderImpl.getEventTypeString(9) + ", " + XMLReaderImpl.getEventTypeString(11) + " valid for getText() ");
    }

    public boolean isAttributeSpecified(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().isSpecified(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLReaderImpl.getEventTypeString(1) + " , " + XMLReaderImpl.getEventTypeString(10) + "valid for isAttributeSpecified()");
    }

    public com.amazonaws.javax.xml.namespace.QName convertXNIQNametoJavaxQName(QName qname) {
        if (qname == null) {
            return null;
        }
        if (qname.prefix == null) {
            return new com.amazonaws.javax.xml.namespace.QName(qname.uri, qname.localpart);
        }
        return new com.amazonaws.javax.xml.namespace.QName(qname.uri, qname.localpart, qname.prefix);
    }

    protected List getEntityDecls() {
        if (this.fEventType == 11) {
            XMLEntityStorage entityStore = this.fEntityManager.getEntityStore();
            Hashtable ht = entityStore.getDeclaredEntities();
            ArrayList<EntityDeclarationImpl> list = null;
            if (ht != null) {
                EntityDeclarationImpl decl = null;
                list = new ArrayList<EntityDeclarationImpl>(ht.size());
                Enumeration enu = ht.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    Entity en = (Entity)ht.get(key);
                    decl = new EntityDeclarationImpl();
                    decl.setEntityName(key);
                    if (en.isExternal()) {
                        decl.setXMLResourceIdentifier(((Entity.ExternalEntity)en).entityLocation);
                        decl.setNotationName(((Entity.ExternalEntity)en).notation);
                    } else {
                        decl.setEntityReplacementText(((Entity.InternalEntity)en).text);
                    }
                    list.add(decl);
                }
            }
            return list;
        }
        return null;
    }

    protected List getNotationDecls() {
        if (this.fEventType == 11) {
            if (this.fScanner.fDTDScanner == null) {
                return null;
            }
            DTDGrammar grammar = ((XMLDTDScannerImpl)this.fScanner.fDTDScanner).getGrammar();
            if (grammar == null) {
                return null;
            }
            List notations = grammar.getNotationDecls();
            Iterator it = notations.iterator();
            ArrayList<NotationDeclarationImpl> list = new ArrayList<NotationDeclarationImpl>();
            while (it.hasNext()) {
                XMLNotationDecl ni = (XMLNotationDecl)it.next();
                if (ni == null) continue;
                list.add(new NotationDeclarationImpl(ni));
            }
            return list;
        }
        return null;
    }
}

