/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CognitoCredentialsProvider
implements AWSCredentialsProvider {
    private final AWSCognitoIdentityProvider identityProvider;
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    public static final int DEFAULT_THRESHOLD_SECONDS = 500;
    protected AWSSessionCredentials sessionCredentials;
    protected Date sessionCredentialsExpiration;
    protected String token;
    protected AWSSecurityTokenService securityTokenService;
    protected int sessionDuration;
    protected int refreshThreshold;
    protected String unauthRoleArn;
    protected String authRoleArn;

    public CognitoCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region) {
        this(accountId, identityPoolId, unauthRoleArn, authRoleArn, region, new ClientConfiguration());
    }

    public CognitoCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region, ClientConfiguration clientConfiguration) {
        AmazonCognitoIdentityClient cib = new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration);
        cib.setRegion(Region.getRegion(region));
        this.identityProvider = new AWSBasicCognitoIdentityProvider(accountId, identityPoolId, cib);
        this.unauthRoleArn = unauthRoleArn;
        this.authRoleArn = authRoleArn;
        this.securityTokenService = new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), clientConfiguration);
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    public CognitoCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, AmazonCognitoIdentityClient cib, AWSSecurityTokenService sts) {
        this(new AWSBasicCognitoIdentityProvider(accountId, identityPoolId, cib), unauthRoleArn, authRoleArn, sts);
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, String unauthArn, String authArn, AWSSecurityTokenService stsClient) {
        this.identityProvider = provider;
        this.unauthRoleArn = unauthArn;
        this.authRoleArn = authArn;
        this.securityTokenService = stsClient;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, String unauthArn, String authArn) {
        this.identityProvider = provider;
        this.unauthRoleArn = unauthArn;
        this.authRoleArn = authArn;
        this.securityTokenService = new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), new ClientConfiguration());
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    public String getIdentityId() {
        return this.identityProvider.getIdentityId();
    }

    public String getToken() {
        return this.identityProvider.getToken();
    }

    public AWSIdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setSessionCredentialsExpiration(Date expiration) {
        this.sessionCredentialsExpiration = expiration;
    }

    public Date getSessionCredentitalsExpiration() {
        return this.sessionCredentialsExpiration;
    }

    public String getIdentityPoolId() {
        return this.identityProvider.getIdentityPoolId();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    public void setSessionDuration(int sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public CognitoCredentialsProvider withSessionDuration(int sessionDuration) {
        this.setSessionDuration(sessionDuration);
        return this;
    }

    public int getSessionDuration() {
        return this.sessionDuration;
    }

    public void setRefreshThreshold(int refreshThreshold) {
        this.refreshThreshold = refreshThreshold;
    }

    public CognitoCredentialsProvider withRefreshThreshold(int refreshThreshold) {
        this.setRefreshThreshold(refreshThreshold);
        return this;
    }

    public int getRefreshThreshold() {
        return this.refreshThreshold;
    }

    protected void setIdentityId(String identityId) {
        this.identityProvider.identityChanged(identityId);
    }

    public void setLogins(Map<String, String> logins) {
        this.identityProvider.setLogins(logins);
        this.sessionCredentials = null;
    }

    public AWSCredentialsProvider withLogins(Map<String, String> logins) {
        this.setLogins(logins);
        return this;
    }

    public Map<String, String> getLogins() {
        return this.identityProvider.getLogins();
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    public void clear() {
        this.sessionCredentials = null;
        this.sessionCredentialsExpiration = null;
        this.setIdentityId(null);
        this.identityProvider.setLogins(new HashMap<String, String>());
    }

    public void clearCredentials() {
        this.sessionCredentials = null;
        this.sessionCredentialsExpiration = null;
    }

    protected void startSession() {
        this.token = this.identityProvider.refresh();
        String roleArn = this.unauthRoleArn;
        Map<String, String> logins = this.identityProvider.getLogins();
        if (logins != null && logins.size() > 0) {
            roleArn = this.authRoleArn;
        }
        AssumeRoleWithWebIdentityRequest sessionTokenRequest = new AssumeRoleWithWebIdentityRequest().withWebIdentityToken(this.token).withRoleArn(roleArn).withRoleSessionName("ProviderSession").withDurationSeconds(this.sessionDuration);
        this.appendUserAgent(sessionTokenRequest, this.getUserAgent());
        AssumeRoleWithWebIdentityResult sessionTokenResult = this.securityTokenService.assumeRoleWithWebIdentity(sessionTokenRequest);
        Credentials stsCredentials = sessionTokenResult.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        this.sessionCredentialsExpiration = stsCredentials.getExpiration();
    }

    protected boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long currentTime = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
        long timeRemaining = this.sessionCredentialsExpiration.getTime() - currentTime;
        return timeRemaining < (long)(this.refreshThreshold * 1000);
    }

    private void appendUserAgent(AmazonWebServiceRequest request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
    }

    protected String getUserAgent() {
        return "";
    }

    public void registerIdentityChangedListener(IdentityChangedListener listener) {
        this.identityProvider.registerIdentityChangedListener(listener);
    }

    public void unregisterIdentityChangedListener(IdentityChangedListener listener) {
        this.identityProvider.unregisterIdentityChangedListener(listener);
    }
}

