/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.util.VersionInfoUtils;
import java.util.Date;
import java.util.Map;

public class CognitoCachingCredentialsProvider
extends CognitoCredentialsProvider {
    private final String DEFAULT_SHAREDPREFERENCES_NAME = "com.amazonaws.android.auth";
    private static final String USER_AGENT = CognitoCachingCredentialsProvider.class.getName() + "/" + VersionInfoUtils.getVersion();
    private final SharedPreferences prefs;
    private String identityId;
    private static final String ID_KEY = "identityId";
    private static final String AK_KEY = "accessKey";
    private static final String SK_KEY = "secretKey";
    private static final String ST_KEY = "sessionToken";
    private static final String EXP_KEY = "expirationDate";
    boolean needIdentityRefresh = false;
    private static final String TAG = "CognitoCachingCredentialsProvider";
    private final IdentityChangedListener listener = new IdentityChangedListener(){

        @Override
        public void identityChanged(String oldIdentityId, String newIdentityId) {
            Log.d((String)CognitoCachingCredentialsProvider.TAG, (String)"Identity id is changed");
            CognitoCachingCredentialsProvider.this.saveIdentityId(newIdentityId);
        }
    };

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region) {
        this(context, accountId, identityPoolId, unauthRoleArn, authRoleArn, region, new ClientConfiguration());
    }

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region, ClientConfiguration clientConfiguration) {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.checkUpgrade();
        this.identityId = this.getCachedIdentityId();
        this.loadCachedCredentials();
        this.registerIdentityChangedListener(this.listener);
    }

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, AmazonCognitoIdentityClient cib, AWSSecurityTokenService sts) {
        this(context, new AWSBasicCognitoIdentityProvider(accountId, identityPoolId, cib), unauthRoleArn, authRoleArn, sts);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, String unauthRoleArn, String authRoleArn, AWSSecurityTokenService sts) {
        super(provider, unauthRoleArn, authRoleArn, sts);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.checkUpgrade();
        this.identityId = this.getCachedIdentityId();
        this.loadCachedCredentials();
        this.registerIdentityChangedListener(this.listener);
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, String unauthRoleArn, String authRoleArn) {
        super(provider, unauthRoleArn, authRoleArn, new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), new ClientConfiguration()));
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.checkUpgrade();
        this.identityId = this.getCachedIdentityId();
        this.loadCachedCredentials();
        this.registerIdentityChangedListener(this.listener);
    }

    @Override
    public String getIdentityId() {
        if (this.needIdentityRefresh) {
            this.needIdentityRefresh = false;
            this.refresh();
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        this.identityId = this.getCachedIdentityId();
        if (this.identityId == null) {
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        return this.identityId;
    }

    @Override
    public synchronized AWSSessionCredentials getCredentials() {
        if (this.sessionCredentials == null) {
            this.loadCachedCredentials();
        }
        if (!this.needsNewSession()) {
            return this.sessionCredentials;
        }
        try {
            super.getCredentials();
        }
        catch (NotAuthorizedException e) {
            Log.e((String)TAG, (String)"Failure to get credentials", (Throwable)e);
            if (this.getLogins() != null) {
                this.clear();
                super.getCredentials();
            }
            throw e;
        }
        this.saveCredentials(this.sessionCredentials, this.getSessionCredentitalsExpiration().getTime());
        return this.sessionCredentials;
    }

    @Override
    public void setLogins(Map<String, String> logins) {
        super.setLogins(logins);
        this.needIdentityRefresh = true;
        this.clearCredentials();
    }

    @Override
    public void clear() {
        super.clear();
        this.prefs.edit().clear().apply();
    }

    @Override
    public void clearCredentials() {
        super.clearCredentials();
        Log.d((String)TAG, (String)"Clearing credentials from SharedPreferences");
        if (this.sessionCredentials != null) {
            this.prefs.edit().remove(this.namespace(AK_KEY)).remove(this.namespace(SK_KEY)).remove(this.namespace(ST_KEY)).remove(this.namespace(EXP_KEY)).apply();
        }
    }

    public String getCachedIdentityId() {
        String cachedIdentityId = this.prefs.getString(this.namespace(ID_KEY), null);
        if (cachedIdentityId != null && this.identityId == null) {
            super.setIdentityId(cachedIdentityId);
        }
        return cachedIdentityId;
    }

    private void loadCachedCredentials() {
        Log.d((String)TAG, (String)"Loading credentials from SharedPreferences");
        this.sessionCredentialsExpiration = new Date(this.prefs.getLong(this.namespace(EXP_KEY), 0L));
        boolean hasAK = this.prefs.contains(this.namespace(AK_KEY));
        boolean hasSK = this.prefs.contains(this.namespace(SK_KEY));
        boolean hasST = this.prefs.contains(this.namespace(ST_KEY));
        if (!(hasAK && hasSK && hasST)) {
            Log.d((String)TAG, (String)"No valid credentials found in SharedPreferences");
            this.sessionCredentialsExpiration = null;
            return;
        }
        String AK = this.prefs.getString(this.namespace(AK_KEY), null);
        String SK = this.prefs.getString(this.namespace(SK_KEY), null);
        String ST = this.prefs.getString(this.namespace(ST_KEY), null);
        this.sessionCredentials = new BasicSessionCredentials(AK, SK, ST);
    }

    private void saveCredentials(AWSSessionCredentials sessionCredentials, long time) {
        Log.d((String)TAG, (String)"Saving credentials to SharedPreferences");
        if (sessionCredentials != null) {
            this.prefs.edit().putString(this.namespace(AK_KEY), sessionCredentials.getAWSAccessKeyId()).putString(this.namespace(SK_KEY), sessionCredentials.getAWSSecretKey()).putString(this.namespace(ST_KEY), sessionCredentials.getSessionToken()).putLong(this.namespace(EXP_KEY), time).apply();
        }
    }

    private void saveIdentityId(String identityId) {
        Log.d((String)TAG, (String)"Saving identity id to SharedPreferences");
        this.identityId = identityId;
        this.prefs.edit().putString(this.namespace(ID_KEY), identityId).apply();
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }

    private void checkUpgrade() {
        if (this.prefs.contains(ID_KEY)) {
            Log.i((String)TAG, (String)"Identity id without namespace is detected. It will be saved under new namespace.");
            String identityId = this.prefs.getString(ID_KEY, null);
            this.prefs.edit().clear().putString(this.namespace(ID_KEY), identityId).apply();
        }
    }

    private String namespace(String key) {
        return this.getIdentityPoolId() + "." + key;
    }
}

