/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public enum ClassLoaderHelper {


    public static URL getResource(String string, Class<?> ... classArray) {
        return ClassLoaderHelper.getResource(string, false, classArray);
    }

    public static URL getResource(String string, boolean bl, Class<?> ... classArray) {
        URL uRL;
        if (bl) {
            uRL = ClassLoaderHelper.getResourceViaClasses(string, classArray);
            if (uRL == null) {
                uRL = ClassLoaderHelper.getResourceViaContext(string);
            }
        } else {
            uRL = ClassLoaderHelper.getResourceViaContext(string);
            if (uRL == null) {
                uRL = ClassLoaderHelper.getResourceViaClasses(string, classArray);
            }
        }
        return uRL == null ? ClassLoaderHelper.class.getResource(string) : uRL;
    }

    private static URL getResourceViaClasses(String string, Class<?>[] classArray) {
        if (classArray != null) {
            for (Class<?> clazz : classArray) {
                URL uRL = clazz.getResource(string);
                if (uRL == null) continue;
                return uRL;
            }
        }
        return null;
    }

    private static URL getResourceViaContext(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? null : classLoader.getResource(string);
    }

    private static Class<?> loadClassViaClasses(String string, Class<?>[] classArray) {
        if (classArray != null) {
            for (Class<?> clazz : classArray) {
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) continue;
                try {
                    return classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Class<?> loadClassViaContext(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader == null ? null : classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> loadClass(String string, Class<?> ... classArray) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(string, true, classArray);
    }

    public static Class<?> loadClass(String string, boolean bl, Class<?> ... classArray) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (bl) {
            clazz = ClassLoaderHelper.loadClassViaClasses(string, classArray);
            if (clazz == null) {
                clazz = ClassLoaderHelper.loadClassViaContext(string);
            }
        } else {
            clazz = ClassLoaderHelper.loadClassViaContext(string);
            if (clazz == null) {
                clazz = ClassLoaderHelper.loadClassViaClasses(string, classArray);
            }
        }
        return clazz == null ? Class.forName(string) : clazz;
    }

    public static InputStream getResourceAsStream(String string, Class<?> ... classArray) {
        return ClassLoaderHelper.getResourceAsStream(string, false, classArray);
    }

    public static InputStream getResourceAsStream(String string, boolean bl, Class<?> ... classArray) {
        URL uRL = ClassLoaderHelper.getResource(string, bl, classArray);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

