/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream;

import com.amazonaws.javax.xml.stream.StaxEntityResolverWrapper;
import com.amazonaws.javax.xml.stream.XMLResolver;
import java.util.HashMap;

public class PropertyManager {
    HashMap supportedProps = new HashMap();

    public PropertyManager(int context) {
        switch (context) {
            case 1: {
                this.initConfigurableReaderProperties();
                break;
            }
            case 2: {
                this.initWriterProps();
            }
        }
    }

    public PropertyManager(PropertyManager propertyManager) {
        HashMap properties = propertyManager.getProperties();
        this.supportedProps.putAll(properties);
    }

    private HashMap getProperties() {
        return this.supportedProps;
    }

    private void initConfigurableReaderProperties() {
        this.supportedProps.put("com.amazonaws.javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.isValidating", Boolean.FALSE);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.supportDTD", Boolean.TRUE);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.reporter", null);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.resolver", null);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.allocator", null);
        this.supportedProps.put("com.amazonaws.javax.xml.stream.notations", null);
        this.supportedProps.put("http://xml.org/sax/features/string-interning", Boolean.TRUE);
        this.supportedProps.put("http://apache.org/xml/features/allow-java-encodings", Boolean.TRUE);
        this.supportedProps.put("reuse-instance", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/ignore-external-dtd", Boolean.FALSE);
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", Boolean.FALSE);
        this.supportedProps.put("http://apache.org/xml/features/warn-on-duplicate-entitydef", Boolean.FALSE);
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/implementation-name", "sjsxp");
    }

    private void initWriterProps() {
        this.supportedProps.put("com.amazonaws.javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        this.supportedProps.put("escapeCharacters", Boolean.TRUE);
        this.supportedProps.put("reuse-instance", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/implementation-name", "sjsxp");
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/outputstream", null);
    }

    public Object getProperty(String property) {
        return this.supportedProps.get(property);
    }

    public void setProperty(String property, Object value) {
        String equivalentProperty = null;
        if (property == "com.amazonaws.javax.xml.stream.isNamespaceAware" || property.equals("com.amazonaws.javax.xml.stream.isNamespaceAware")) {
            equivalentProperty = "http://apache.org/xml/features/namespaces";
        } else if (property == "com.amazonaws.javax.xml.stream.isValidating" || property.equals("com.amazonaws.javax.xml.stream.isValidating")) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                throw new IllegalArgumentException("true value of isValidating not supported");
            }
        } else if (property == "http://xml.org/sax/features/string-interning" || property.equals("http://xml.org/sax/features/string-interning")) {
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                throw new IllegalArgumentException("false value of http://xml.org/sax/features/string-interningfeature is not supported");
            }
        } else if (property == "com.amazonaws.javax.xml.stream.resolver" || property.equals("com.amazonaws.javax.xml.stream.resolver")) {
            this.supportedProps.put("http://apache.org/xml/properties/internal/stax-entity-resolver", new StaxEntityResolverWrapper((XMLResolver)value));
        }
        this.supportedProps.put(property, value);
        if (equivalentProperty != null) {
            this.supportedProps.put(equivalentProperty, value);
        }
    }

    public String toString() {
        return this.supportedProps.toString();
    }
}

