/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.core.json;

import com.amazonaws.com.fasterxml.jackson.core.Base64Variant;
import com.amazonaws.com.fasterxml.jackson.core.JsonParseException;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.ObjectCodec;
import com.amazonaws.com.fasterxml.jackson.core.base.ParserBase;
import com.amazonaws.com.fasterxml.jackson.core.io.CharTypes;
import com.amazonaws.com.fasterxml.jackson.core.io.IOContext;
import com.amazonaws.com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.amazonaws.com.fasterxml.jackson.core.sym.Name;
import com.amazonaws.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8StreamJsonParser
extends ParserBase {
    private static final int[] sInputCodesUtf8 = CharTypes.getInputCodeUtf8();
    private static final int[] sInputCodesLatin1 = CharTypes.getInputCodeLatin1();
    protected ObjectCodec _objectCodec;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete = false;
    private int _quad1;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    public UTF8StreamJsonParser(IOContext ctxt, int features, InputStream in, ObjectCodec codec, BytesToNameCanonicalizer sym, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(ctxt, features);
        this._inputStream = in;
        this._objectCodec = codec;
        this._symbols = sym;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    protected boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._inputStream != null) {
            int count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count > 0) {
                this._inputPtr = 0;
                this._inputEnd = count;
                return true;
            }
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        byte[] buf;
        super._releaseBuffers();
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public String getValueAsString() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String defValue) throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return super.getValueAsString(defValue);
    }

    protected String _getText2(JsonToken t) {
        if (t == null) {
            return null;
        }
        switch (t) {
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this._textBuffer.contentsAsString();
            }
        }
        return t.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String name = this._parsingContext.getCurrentName();
                        int nameLen = name.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(nameLen);
                        } else if (this._nameCopyBuffer.length < nameLen) {
                            this._nameCopyBuffer = new char[nameLen];
                        }
                        name.getChars(0, nameLen, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return 0;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        JsonToken jsonToken;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            return this._nextTokenNotInObject(n);
        }
        Name name = this._parseFieldName(n);
        this._parsingContext.setCurrentName(name.getName());
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipWS();
        if (n != 58) {
            this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
        }
        if ((n = this._skipWS()) == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this.parseNumberText(n);
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private JsonToken _nextTokenNotInObject(int n) throws IOException, JsonParseException {
        if (n == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this.parseNumberText(n);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n);
        return this._currToken;
    }

    private JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken t = this._nextToken;
        this._nextToken = null;
        if (t == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (t == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = t;
        return this._currToken;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    protected JsonToken parseNumberText(int c) throws IOException, JsonParseException {
        boolean negative;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        boolean bl = negative = c == 45;
        if (negative) {
            outBuf[outPtr++] = 45;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || c > 57) {
                return this._handleInvalidNumberStart(c, true);
            }
        }
        if (c == 48) {
            c = this._verifyNoLeadingZeroes();
        }
        outBuf[outPtr++] = (char)c;
        int intLen = 1;
        int end = this._inputPtr + outBuf.length;
        if (end > this._inputEnd) {
            end = this._inputEnd;
        }
        while (true) {
            if (this._inputPtr >= end) {
                return this._parserNumber2(outBuf, outPtr, negative, intLen);
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || c > 57) break;
            ++intLen;
            outBuf[outPtr++] = (char)c;
        }
        if (c == 46 || c == 101 || c == 69) {
            return this._parseFloatText(outBuf, outPtr, c, negative, intLen);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(outPtr);
        return this.resetInt(negative, intLen);
    }

    private JsonToken _parserNumber2(char[] outBuf, int outPtr, boolean negative, int intPartLength) throws IOException, JsonParseException {
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuffer.setCurrentLength(outPtr);
                return this.resetInt(negative, intPartLength);
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) > 57 || c < 48) {
                if (c != 46 && c != 101 && c != 69) break;
                return this._parseFloatText(outBuf, outPtr, c, negative, intPartLength);
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
            ++intPartLength;
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(outPtr);
        return this.resetInt(negative, intPartLength);
    }

    private int _verifyNoLeadingZeroes() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return 48;
        }
        int n = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n < 48 || n > 57) {
            return 48;
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (n == 48) {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                n = this._inputBuffer[this._inputPtr] & 0xFF;
                if (n < 48 || n > 57) {
                    return 48;
                }
                ++this._inputPtr;
                if (n == 48) continue;
                break;
            }
        }
        return n;
    }

    private JsonToken _parseFloatText(char[] cArray, int n, int n2, boolean bl, int n3) throws IOException, JsonParseException {
        int n4 = 0;
        boolean bl2 = false;
        if (n2 == 46) {
            cArray[n++] = (char)n2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
                ++n4;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (n2 == 101 || n2 == 69) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || n2 == 43) {
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (n2 <= 57 && n2 >= 48) {
                ++n5;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
        }
        this._textBuffer.setCurrentLength(n);
        return this.resetFloat(bl, n3, n4, n5);
    }

    protected Name _parseFieldName(int i) throws IOException, JsonParseException {
        int q;
        if (i != 34) {
            return this._handleUnusualFieldName(i);
        }
        if (this._inputPtr + 9 > this._inputEnd) {
            return this.slowParseFieldName();
        }
        int[] codes = sInputCodesLatin1;
        byte[] input = this._inputBuffer;
        if (codes[q = input[this._inputPtr++] & 0xFF] == 0) {
            if (codes[i = input[this._inputPtr++] & 0xFF] == 0) {
                q = q << 8 | i;
                if (codes[i = input[this._inputPtr++] & 0xFF] == 0) {
                    q = q << 8 | i;
                    if (codes[i = input[this._inputPtr++] & 0xFF] == 0) {
                        q = q << 8 | i;
                        if (codes[i = input[this._inputPtr++] & 0xFF] == 0) {
                            this._quad1 = q;
                            return this.parseMediumFieldName(i, codes);
                        }
                        if (i == 34) {
                            return this.findName(q, 4);
                        }
                        return this.parseFieldName(q, i, 4);
                    }
                    if (i == 34) {
                        return this.findName(q, 3);
                    }
                    return this.parseFieldName(q, i, 3);
                }
                if (i == 34) {
                    return this.findName(q, 2);
                }
                return this.parseFieldName(q, i, 2);
            }
            if (i == 34) {
                return this.findName(q, 1);
            }
            return this.parseFieldName(q, i, 1);
        }
        if (q == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseFieldName(0, q, 0);
    }

    protected Name parseMediumFieldName(int q2, int[] codes) throws IOException, JsonParseException {
        int i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(this._quad1, q2, 1);
            }
            return this.parseFieldName(this._quad1, q2, i, 1);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(this._quad1, q2, 2);
            }
            return this.parseFieldName(this._quad1, q2, i, 2);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(this._quad1, q2, 3);
            }
            return this.parseFieldName(this._quad1, q2, i, 3);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(this._quad1, q2, 4);
            }
            return this.parseFieldName(this._quad1, q2, i, 4);
        }
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = q2;
        return this.parseLongFieldName(i);
    }

    protected Name parseLongFieldName(int q) throws IOException, JsonParseException {
        int[] codes = sInputCodesLatin1;
        int qlen = 2;
        while (this._inputEnd - this._inputPtr >= 4) {
            int i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 1);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 1);
            }
            q = q << 8 | i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 2);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 2);
            }
            q = q << 8 | i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 3);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 3);
            }
            q = q << 8 | i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 4);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 4);
            }
            if (qlen >= this._quadBuffer.length) {
                this._quadBuffer = UTF8StreamJsonParser.growArrayBy(this._quadBuffer, qlen);
            }
            this._quadBuffer[qlen++] = q;
            q = i;
        }
        return this.parseEscapedFieldName(this._quadBuffer, qlen, 0, q, 0);
    }

    protected Name slowParseFieldName() throws IOException, JsonParseException {
        int n;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedFieldName(this._quadBuffer, 0, 0, n, 0);
    }

    private Name parseFieldName(int q1, int ch, int lastQuadBytes) throws IOException, JsonParseException {
        return this.parseEscapedFieldName(this._quadBuffer, 0, q1, ch, lastQuadBytes);
    }

    private Name parseFieldName(int q1, int q2, int ch, int lastQuadBytes) throws IOException, JsonParseException {
        this._quadBuffer[0] = q1;
        return this.parseEscapedFieldName(this._quadBuffer, 1, q2, ch, lastQuadBytes);
    }

    protected Name parseEscapedFieldName(int[] nArray, int n, int n2, int n3, int n4) throws IOException, JsonParseException {
        Name name;
        int[] nArray2 = sInputCodesLatin1;
        while (true) {
            if (nArray2[n3] != 0) {
                if (n3 == 34) break;
                if (n3 != 92) {
                    this._throwUnquotedSpace(n3, "name");
                } else {
                    n3 = this._decodeEscaped();
                }
                if (n3 > 127) {
                    if (n4 >= 4) {
                        if (n >= nArray.length) {
                            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n++] = n2;
                        n2 = 0;
                        n4 = 0;
                    }
                    if (n3 < 2048) {
                        n2 = n2 << 8 | (0xC0 | n3 >> 6);
                        ++n4;
                    } else {
                        n2 = n2 << 8 | (0xE0 | n3 >> 12);
                        if (++n4 >= 4) {
                            if (n >= nArray.length) {
                                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n++] = n2;
                            n2 = 0;
                            n4 = 0;
                        }
                        n2 = n2 << 8 | (0x80 | n3 >> 6 & 0x3F);
                        ++n4;
                    }
                    n3 = 0x80 | n3 & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n2 = n2 << 8 | n3;
            } else {
                if (n >= nArray.length) {
                    nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n++] = n2;
                n2 = n3;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n >= nArray.length) {
                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n++] = n2;
        }
        if ((name = this._symbols.findName(nArray, n)) == null) {
            name = this.addName(nArray, n, n4);
        }
        return name;
    }

    protected Name _handleUnusualFieldName(int n) throws IOException, JsonParseException {
        Name name;
        int[] nArray;
        if (n == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n] != 0) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray2.length) {
                    this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                }
                nArray2[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            if (nArray[n = this._inputBuffer[this._inputPtr] & 0xFF] != 0) break;
            ++this._inputPtr;
        }
        if (n4 > 0) {
            if (n2 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n2++] = n3;
        }
        if ((name = this._symbols.findName(nArray2, n2)) == null) {
            name = this.addName(nArray2, n2, n4);
        }
        return name;
    }

    protected Name _parseApostropheFieldName() throws IOException, JsonParseException {
        Name name;
        int n;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for name");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        int[] nArray = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray2 = sInputCodesLatin1;
        while (n != 39) {
            if (n != 34 && nArray2[n] != 0) {
                if (n != 92) {
                    this._throwUnquotedSpace(n, "name");
                } else {
                    n = this._decodeEscaped();
                }
                if (n > 127) {
                    if (n4 >= 4) {
                        if (n2 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n4 = 0;
                    }
                    if (n < 2048) {
                        n3 = n3 << 8 | (0xC0 | n >> 6);
                        ++n4;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n >> 12);
                        if (++n4 >= 4) {
                            if (n2 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n4 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n >> 6 & 0x3F);
                        ++n4;
                    }
                    n = 0x80 | n & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = n3;
        }
        if ((name = this._symbols.findName(nArray, n2)) == null) {
            name = this.addName(nArray, n2, n4);
        }
        return name;
    }

    private Name findName(int q1, int lastQuadBytes) throws JsonParseException {
        Name name = this._symbols.findName(q1);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = q1;
        return this.addName(this._quadBuffer, 1, lastQuadBytes);
    }

    private Name findName(int q1, int q2, int lastQuadBytes) throws JsonParseException {
        Name name = this._symbols.findName(q1, q2);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        return this.addName(this._quadBuffer, 2, lastQuadBytes);
    }

    private Name findName(int[] quads, int qlen, int lastQuad, int lastQuadBytes) throws JsonParseException {
        if (qlen >= quads.length) {
            quads = UTF8StreamJsonParser.growArrayBy(quads, quads.length);
            this._quadBuffer = quads;
        }
        quads[qlen++] = lastQuad;
        Name name = this._symbols.findName(quads, qlen);
        if (name == null) {
            return this.addName(quads, qlen, lastQuadBytes);
        }
        return name;
    }

    private Name addName(int[] nArray, int n, int n2) throws JsonParseException {
        int n3;
        int n4 = (n << 2) - 4 + n2;
        if (n2 < 4) {
            n3 = nArray[n - 1];
            nArray[n - 1] = n3 << (4 - n2 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n4) {
                    this._reportInvalidEOF(" in field name");
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n2 < 4) {
            nArray[n - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n);
    }

    protected void _finishString() throws IOException, JsonParseException {
        int ptr = this._inputPtr;
        if (ptr >= this._inputEnd) {
            this.loadMoreGuaranteed();
            ptr = this._inputPtr;
        }
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = sInputCodesUtf8;
        int max = Math.min(this._inputEnd, ptr + outBuf.length);
        byte[] inputBuffer = this._inputBuffer;
        while (ptr < max) {
            int c = inputBuffer[ptr] & 0xFF;
            if (codes[c] != 0) {
                if (c != 34) break;
                this._inputPtr = ptr + 1;
                this._textBuffer.setCurrentLength(outPtr);
                return;
            }
            ++ptr;
            outBuf[outPtr++] = (char)c;
        }
        this._inputPtr = ptr;
        this._finishString2(outBuf, outPtr);
    }

    private void _finishString2(char[] cArray, int n) throws IOException, JsonParseException {
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n2;
            int n3;
            block15: {
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                int n4 = Math.min(this._inputEnd, n3 + (cArray.length - n));
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
                        cArray[n++] = (char)n2;
                        continue;
                    }
                    break block15;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                        break;
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n;
            int n2;
            block10: {
                int n3;
                if ((n2 = this._inputPtr) >= (n3 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                }
                while (n2 < n3) {
                    if (nArray[n = byArray[n2++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n2;
                continue;
            }
            this._inputPtr = n2;
            if (n == 34) break;
            switch (nArray[n]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block6;
                }
            }
            if (n < 32) {
                this._throwUnquotedSpace(n, "string value");
                continue;
            }
            this._reportInvalidChar(n);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n) throws IOException, JsonParseException {
        switch (n) {
            case 39: {
                if (!this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApostropheValue();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++] & 0xFF, false);
            }
        }
        this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApostropheValue() throws IOException, JsonParseException {
        int n = 0;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n3;
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            if ((n4 = this._inputPtr + (cArray.length - n2)) < (n3 = this._inputEnd)) {
                n3 = n4;
            }
            while (true) {
                if (this._inputPtr >= n3) continue block6;
                if ((n = byArray[this._inputPtr++] & 0xFF) == 39 || nArray[n] != 0) break;
                cArray[n2++] = (char)n;
            }
            if (n == 39) break;
            switch (nArray[n]) {
                case 1: {
                    if (n == 34) break;
                    n = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n = this._decodeUtf8_2(n);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n = this._decodeUtf8_3fast(n);
                        break;
                    }
                    n = this._decodeUtf8_3(n);
                    break;
                }
                case 4: {
                    n = this._decodeUtf8_4(n);
                    cArray[n2++] = (char)(0xD800 | n >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n = 0xDC00 | n & 0x3FF;
                    break;
                }
                default: {
                    if (n < 32) {
                        this._throwUnquotedSpace(n, "string value");
                    }
                    this._reportInvalidChar(n);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) throws IOException, JsonParseException {
        if (n == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((n = this._inputBuffer[this._inputPtr++]) == 78) {
                String string = bl ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected void _matchToken(String string, int n) throws IOException, JsonParseException {
        int n2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in a value");
            }
            if (this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n), "'null', 'true', 'false' or NaN");
            }
            ++this._inputPtr;
        } while (++n < n2);
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return;
        }
        int n3 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n3 < 48 || n3 == 93 || n3 == 125) {
            return;
        }
        char c = (char)this._decodeCharForError(n3);
        if (Character.isJavaIdentifierPart(c)) {
            ++this._inputPtr;
            this._reportInvalidToken(string.substring(0, n), "'null', 'true', 'false' or NaN");
        }
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException, JsonParseException {
        byte by;
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c = (char)this._decodeCharForError(by = this._inputBuffer[this._inputPtr++]))) {
            stringBuilder.append(c);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting " + string2);
    }

    private int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n != 47) {
                    return n;
                }
                this._skipComment();
                continue;
            }
            if (n == 32) continue;
            if (n == 10) {
                this._skipLF();
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private int _skipWSOrEnd() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int i;
            if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (i != 47) {
                    return i;
                }
                this._skipComment();
                continue;
            }
            if (i == 32) continue;
            if (i == 10) {
                this._skipLF();
                continue;
            }
            if (i == 13) {
                this._skipCR();
                continue;
            }
            if (i == 9) continue;
            this._throwInvalidSpace(i);
        }
        this._handleEOF();
        return -1;
    }

    private void _skipComment() throws IOException, JsonParseException {
        int n;
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipCppComment();
        } else if (n == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n, "was expecting either '*' or '/' for a comment");
        }
    }

    private void _skipCComment() throws IOException, JsonParseException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    this._skipLF();
                    break;
                }
                case 13: {
                    this._skipCR();
                    break;
                }
                case 2: {
                    this._skipUtf8_2(n);
                    break;
                }
                case 3: {
                    this._skipUtf8_3(n);
                    break;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    break;
                }
                default: {
                    this._reportInvalidChar(n);
                }
            }
        }
        this._reportInvalidEOF(" in a comment");
    }

    private void _skipCppComment() throws IOException, JsonParseException {
        int[] codes = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int i;
            int code;
            if ((code = codes[i = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (code) {
                case 10: {
                    this._skipLF();
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block8;
                }
                case 2: {
                    this._skipUtf8_2(i);
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3(i);
                    continue block8;
                }
                case 4: {
                    this._skipUtf8_4(i);
                    continue block8;
                }
            }
            this._reportInvalidChar(i);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        byte by = this._inputBuffer[this._inputPtr++];
        switch (by) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(by));
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            byte by2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n2 = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    protected int _decodeCharForError(int firstByte) throws IOException, JsonParseException {
        int c = firstByte;
        if (c < 0) {
            int needed;
            if ((c & 0xE0) == 192) {
                c &= 0x1F;
                needed = 1;
            } else if ((c & 0xF0) == 224) {
                c &= 0xF;
                needed = 2;
            } else if ((c & 0xF8) == 240) {
                c &= 7;
                needed = 3;
            } else {
                this._reportInvalidInitial(c & 0xFF);
                needed = 1;
            }
            int d = this.nextByte();
            if ((d & 0xC0) != 128) {
                this._reportInvalidOther(d & 0xFF);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 1) {
                d = this.nextByte();
                if ((d & 0xC0) != 128) {
                    this._reportInvalidOther(d & 0xFF);
                }
                c = c << 6 | d & 0x3F;
                if (needed > 2) {
                    d = this.nextByte();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF);
                    }
                    c = c << 6 | d & 0x3F;
                }
            }
        }
        return c;
    }

    private int _decodeUtf8_2(int c) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private int _decodeUtf8_3(int c1) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private int _decodeUtf8_3fast(int c1) throws IOException, JsonParseException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private int _decodeUtf8_4(int n) throws IOException, JsonParseException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    private void _skipUtf8_2(int c) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(c & 0xFF, this._inputPtr);
        }
    }

    private void _skipUtf8_3(int c) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(c & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(c & 0xFF, this._inputPtr);
        }
    }

    private void _skipUtf8_4(int c) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    protected void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected void _skipLF() throws IOException {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    public static int[] growArrayBy(int[] arr, int more) {
        if (arr == null) {
            return new int[more];
        }
        int[] old = arr;
        int len = arr.length;
        arr = new int[len + more];
        System.arraycopy(old, 0, arr, 0, len);
        return arr;
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, n, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, n, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    if (n == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n3 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                        throw this.reportInvalidBase64Char(base64Variant, n, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    if (n == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }
}

