/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;
import com.amazonaws.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class RegisterMfaContinuation
extends ChallengeContinuation {
    private List<String> mfaOptions = this.getListFromString((String)this.getParameters().get("MFAS_CAN_SETUP"));

    public RegisterMfaContinuation(CognitoUser user, Context context, String username, String clientId, String secretHash, RespondToAuthChallengeResult challengeResult, boolean runInBackground, AuthenticationHandler callback) {
        super(user, context, username, clientId, secretHash, challengeResult, runInBackground, callback);
    }

    public List<String> getMfaOptions() {
        if (this.mfaOptions == null) {
            this.mfaOptions = this.getListFromString((String)this.getParameters().get("MFAS_CAN_SETUP"));
        }
        return this.mfaOptions;
    }

    public void setSessionToken(String sessionToken) {
        if (StringUtils.isBlank((CharSequence)sessionToken)) {
            throw new CognitoParameterInvalidException("session token cannot be null");
        }
        this.setResponseSessionCode(sessionToken);
    }

    @Override
    public void continueTask() {
        super.continueTask();
    }

    private List<String> getListFromString(String listString) {
        String mfas = listString.replace("[", "").replace("]", "").replace("\"", "");
        return Arrays.asList(mfas.split(","));
    }
}

