/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SchemaAttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class AddCustomAttributesRequestMarshaller
implements Marshaller<Request<AddCustomAttributesRequest>, AddCustomAttributesRequest> {
    public Request<AddCustomAttributesRequest> marshall(AddCustomAttributesRequest addCustomAttributesRequest) {
        if (addCustomAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AddCustomAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addCustomAttributesRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AddCustomAttributes";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (addCustomAttributesRequest.getUserPoolId() != null) {
                String userPoolId = addCustomAttributesRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (addCustomAttributesRequest.getCustomAttributes() != null) {
                List<SchemaAttributeType> customAttributes = addCustomAttributesRequest.getCustomAttributes();
                jsonWriter.name("CustomAttributes");
                jsonWriter.beginArray();
                for (SchemaAttributeType customAttributesItem : customAttributes) {
                    if (customAttributesItem == null) continue;
                    SchemaAttributeTypeJsonMarshaller.getInstance().marshall(customAttributesItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

