/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.MessageTemplateType;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class MessageTemplateTypeJsonUnmarshaller
implements Unmarshaller<MessageTemplateType, JsonUnmarshallerContext> {
    private static MessageTemplateTypeJsonUnmarshaller instance;

    MessageTemplateTypeJsonUnmarshaller() {
    }

    public MessageTemplateType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        MessageTemplateType messageTemplateType = new MessageTemplateType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("SMSMessage")) {
                messageTemplateType.setSMSMessage(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EmailMessage")) {
                messageTemplateType.setEmailMessage(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("EmailSubject")) {
                messageTemplateType.setEmailSubject(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return messageTemplateType;
    }

    public static MessageTemplateTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageTemplateTypeJsonUnmarshaller();
        }
        return instance;
    }
}

