/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.SetUICustomizationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;

public class SetUICustomizationRequestMarshaller
implements Marshaller<Request<SetUICustomizationRequest>, SetUICustomizationRequest> {
    public Request<SetUICustomizationRequest> marshall(SetUICustomizationRequest setUICustomizationRequest) {
        if (setUICustomizationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetUICustomizationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setUICustomizationRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.SetUICustomization";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (setUICustomizationRequest.getUserPoolId() != null) {
                String userPoolId = setUICustomizationRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (setUICustomizationRequest.getClientId() != null) {
                String clientId = setUICustomizationRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (setUICustomizationRequest.getCSS() != null) {
                String cSS = setUICustomizationRequest.getCSS();
                jsonWriter.name("CSS");
                jsonWriter.value(cSS);
            }
            if (setUICustomizationRequest.getImageFile() != null) {
                ByteBuffer imageFile = setUICustomizationRequest.getImageFile();
                jsonWriter.name("ImageFile");
                jsonWriter.value(imageFile);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

