/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.DeviceSecretVerifierConfigTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ConfirmDeviceRequestMarshaller
implements Marshaller<Request<ConfirmDeviceRequest>, ConfirmDeviceRequest> {
    public Request<ConfirmDeviceRequest> marshall(ConfirmDeviceRequest confirmDeviceRequest) {
        if (confirmDeviceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ConfirmDeviceRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmDeviceRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.ConfirmDevice";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (confirmDeviceRequest.getAccessToken() != null) {
                String accessToken = confirmDeviceRequest.getAccessToken();
                jsonWriter.name("AccessToken");
                jsonWriter.value(accessToken);
            }
            if (confirmDeviceRequest.getDeviceKey() != null) {
                String deviceKey = confirmDeviceRequest.getDeviceKey();
                jsonWriter.name("DeviceKey");
                jsonWriter.value(deviceKey);
            }
            if (confirmDeviceRequest.getDeviceSecretVerifierConfig() != null) {
                DeviceSecretVerifierConfigType deviceSecretVerifierConfig = confirmDeviceRequest.getDeviceSecretVerifierConfig();
                jsonWriter.name("DeviceSecretVerifierConfig");
                DeviceSecretVerifierConfigTypeJsonMarshaller.getInstance().marshall(deviceSecretVerifierConfig, jsonWriter);
            }
            if (confirmDeviceRequest.getDeviceName() != null) {
                String deviceName = confirmDeviceRequest.getDeviceName();
                jsonWriter.name("DeviceName");
                jsonWriter.value(deviceName);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

