/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.ContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.HttpHeader;
import com.amazonaws.services.cognitoidentityprovider.model.transform.HttpHeaderJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class ContextDataTypeJsonMarshaller {
    private static ContextDataTypeJsonMarshaller instance;

    ContextDataTypeJsonMarshaller() {
    }

    public void marshall(ContextDataType contextDataType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (contextDataType.getIpAddress() != null) {
            String ipAddress = contextDataType.getIpAddress();
            jsonWriter.name("IpAddress");
            jsonWriter.value(ipAddress);
        }
        if (contextDataType.getServerName() != null) {
            String serverName = contextDataType.getServerName();
            jsonWriter.name("ServerName");
            jsonWriter.value(serverName);
        }
        if (contextDataType.getServerPath() != null) {
            String serverPath = contextDataType.getServerPath();
            jsonWriter.name("ServerPath");
            jsonWriter.value(serverPath);
        }
        if (contextDataType.getHttpHeaders() != null) {
            List<HttpHeader> httpHeaders = contextDataType.getHttpHeaders();
            jsonWriter.name("HttpHeaders");
            jsonWriter.beginArray();
            for (HttpHeader httpHeadersItem : httpHeaders) {
                if (httpHeadersItem == null) continue;
                HttpHeaderJsonMarshaller.getInstance().marshall(httpHeadersItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (contextDataType.getEncodedData() != null) {
            String encodedData = contextDataType.getEncodedData();
            jsonWriter.name("EncodedData");
            jsonWriter.value(encodedData);
        }
        jsonWriter.endObject();
    }

    public static ContextDataTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContextDataTypeJsonMarshaller();
        }
        return instance;
    }
}

