/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AccountRecoverySettingType;
import com.amazonaws.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.EmailConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.SmsConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.UserAttributeUpdateSettingsType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolAddOnsType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.UsernameConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AccountRecoverySettingTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AdminCreateUserConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.DeviceConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.EmailConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.LambdaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SchemaAttributeTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.SmsConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserAttributeUpdateSettingsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserPoolAddOnsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UserPoolPolicyTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.UsernameConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.VerificationMessageTemplateTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class CreateUserPoolRequestMarshaller
implements Marshaller<Request<CreateUserPoolRequest>, CreateUserPoolRequest> {
    public Request<CreateUserPoolRequest> marshall(CreateUserPoolRequest createUserPoolRequest) {
        if (createUserPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateUserPoolRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserPoolRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.CreateUserPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createUserPoolRequest.getPoolName() != null) {
                String poolName = createUserPoolRequest.getPoolName();
                jsonWriter.name("PoolName");
                jsonWriter.value(poolName);
            }
            if (createUserPoolRequest.getPolicies() != null) {
                UserPoolPolicyType policies = createUserPoolRequest.getPolicies();
                jsonWriter.name("Policies");
                UserPoolPolicyTypeJsonMarshaller.getInstance().marshall(policies, jsonWriter);
            }
            if (createUserPoolRequest.getDeletionProtection() != null) {
                String deletionProtection = createUserPoolRequest.getDeletionProtection();
                jsonWriter.name("DeletionProtection");
                jsonWriter.value(deletionProtection);
            }
            if (createUserPoolRequest.getLambdaConfig() != null) {
                LambdaConfigType lambdaConfig = createUserPoolRequest.getLambdaConfig();
                jsonWriter.name("LambdaConfig");
                LambdaConfigTypeJsonMarshaller.getInstance().marshall(lambdaConfig, jsonWriter);
            }
            if (createUserPoolRequest.getAutoVerifiedAttributes() != null) {
                List<String> autoVerifiedAttributes = createUserPoolRequest.getAutoVerifiedAttributes();
                jsonWriter.name("AutoVerifiedAttributes");
                jsonWriter.beginArray();
                for (String string : autoVerifiedAttributes) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolRequest.getAliasAttributes() != null) {
                List<String> aliasAttributes = createUserPoolRequest.getAliasAttributes();
                jsonWriter.name("AliasAttributes");
                jsonWriter.beginArray();
                for (String string : aliasAttributes) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolRequest.getUsernameAttributes() != null) {
                List<String> usernameAttributes = createUserPoolRequest.getUsernameAttributes();
                jsonWriter.name("UsernameAttributes");
                jsonWriter.beginArray();
                for (String string : usernameAttributes) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolRequest.getSmsVerificationMessage() != null) {
                String smsVerificationMessage = createUserPoolRequest.getSmsVerificationMessage();
                jsonWriter.name("SmsVerificationMessage");
                jsonWriter.value(smsVerificationMessage);
            }
            if (createUserPoolRequest.getEmailVerificationMessage() != null) {
                String emailVerificationMessage = createUserPoolRequest.getEmailVerificationMessage();
                jsonWriter.name("EmailVerificationMessage");
                jsonWriter.value(emailVerificationMessage);
            }
            if (createUserPoolRequest.getEmailVerificationSubject() != null) {
                String emailVerificationSubject = createUserPoolRequest.getEmailVerificationSubject();
                jsonWriter.name("EmailVerificationSubject");
                jsonWriter.value(emailVerificationSubject);
            }
            if (createUserPoolRequest.getVerificationMessageTemplate() != null) {
                VerificationMessageTemplateType verificationMessageTemplate = createUserPoolRequest.getVerificationMessageTemplate();
                jsonWriter.name("VerificationMessageTemplate");
                VerificationMessageTemplateTypeJsonMarshaller.getInstance().marshall(verificationMessageTemplate, jsonWriter);
            }
            if (createUserPoolRequest.getSmsAuthenticationMessage() != null) {
                String smsAuthenticationMessage = createUserPoolRequest.getSmsAuthenticationMessage();
                jsonWriter.name("SmsAuthenticationMessage");
                jsonWriter.value(smsAuthenticationMessage);
            }
            if (createUserPoolRequest.getMfaConfiguration() != null) {
                String mfaConfiguration = createUserPoolRequest.getMfaConfiguration();
                jsonWriter.name("MfaConfiguration");
                jsonWriter.value(mfaConfiguration);
            }
            if (createUserPoolRequest.getUserAttributeUpdateSettings() != null) {
                UserAttributeUpdateSettingsType userAttributeUpdateSettings = createUserPoolRequest.getUserAttributeUpdateSettings();
                jsonWriter.name("UserAttributeUpdateSettings");
                UserAttributeUpdateSettingsTypeJsonMarshaller.getInstance().marshall(userAttributeUpdateSettings, jsonWriter);
            }
            if (createUserPoolRequest.getDeviceConfiguration() != null) {
                DeviceConfigurationType deviceConfiguration = createUserPoolRequest.getDeviceConfiguration();
                jsonWriter.name("DeviceConfiguration");
                DeviceConfigurationTypeJsonMarshaller.getInstance().marshall(deviceConfiguration, jsonWriter);
            }
            if (createUserPoolRequest.getEmailConfiguration() != null) {
                EmailConfigurationType emailConfiguration = createUserPoolRequest.getEmailConfiguration();
                jsonWriter.name("EmailConfiguration");
                EmailConfigurationTypeJsonMarshaller.getInstance().marshall(emailConfiguration, jsonWriter);
            }
            if (createUserPoolRequest.getSmsConfiguration() != null) {
                SmsConfigurationType smsConfiguration = createUserPoolRequest.getSmsConfiguration();
                jsonWriter.name("SmsConfiguration");
                SmsConfigurationTypeJsonMarshaller.getInstance().marshall(smsConfiguration, jsonWriter);
            }
            if (createUserPoolRequest.getUserPoolTags() != null) {
                Map<String, String> userPoolTags = createUserPoolRequest.getUserPoolTags();
                jsonWriter.name("UserPoolTags");
                jsonWriter.beginObject();
                for (Map.Entry entry : userPoolTags.entrySet()) {
                    String userPoolTagsValue = (String)entry.getValue();
                    if (userPoolTagsValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(userPoolTagsValue);
                }
                jsonWriter.endObject();
            }
            if (createUserPoolRequest.getAdminCreateUserConfig() != null) {
                AdminCreateUserConfigType adminCreateUserConfig = createUserPoolRequest.getAdminCreateUserConfig();
                jsonWriter.name("AdminCreateUserConfig");
                AdminCreateUserConfigTypeJsonMarshaller.getInstance().marshall(adminCreateUserConfig, jsonWriter);
            }
            if (createUserPoolRequest.getSchema() != null) {
                List<SchemaAttributeType> schema = createUserPoolRequest.getSchema();
                jsonWriter.name("Schema");
                jsonWriter.beginArray();
                for (SchemaAttributeType schemaAttributeType : schema) {
                    if (schemaAttributeType == null) continue;
                    SchemaAttributeTypeJsonMarshaller.getInstance().marshall(schemaAttributeType, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolRequest.getUserPoolAddOns() != null) {
                UserPoolAddOnsType userPoolAddOns = createUserPoolRequest.getUserPoolAddOns();
                jsonWriter.name("UserPoolAddOns");
                UserPoolAddOnsTypeJsonMarshaller.getInstance().marshall(userPoolAddOns, jsonWriter);
            }
            if (createUserPoolRequest.getUsernameConfiguration() != null) {
                UsernameConfigurationType usernameConfiguration = createUserPoolRequest.getUsernameConfiguration();
                jsonWriter.name("UsernameConfiguration");
                UsernameConfigurationTypeJsonMarshaller.getInstance().marshall(usernameConfiguration, jsonWriter);
            }
            if (createUserPoolRequest.getAccountRecoverySetting() != null) {
                AccountRecoverySettingType accountRecoverySetting = createUserPoolRequest.getAccountRecoverySetting();
                jsonWriter.name("AccountRecoverySetting");
                AccountRecoverySettingTypeJsonMarshaller.getInstance().marshall(accountRecoverySetting, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

