/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.ContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsMetadataTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.ContextDataTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class AdminRespondToAuthChallengeRequestMarshaller
implements Marshaller<Request<AdminRespondToAuthChallengeRequest>, AdminRespondToAuthChallengeRequest> {
    public Request<AdminRespondToAuthChallengeRequest> marshall(AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        if (adminRespondToAuthChallengeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AdminRespondToAuthChallengeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminRespondToAuthChallengeRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminRespondToAuthChallenge";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminRespondToAuthChallengeRequest.getUserPoolId() != null) {
                String userPoolId = adminRespondToAuthChallengeRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (adminRespondToAuthChallengeRequest.getClientId() != null) {
                String clientId = adminRespondToAuthChallengeRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (adminRespondToAuthChallengeRequest.getChallengeName() != null) {
                String challengeName = adminRespondToAuthChallengeRequest.getChallengeName();
                jsonWriter.name("ChallengeName");
                jsonWriter.value(challengeName);
            }
            if (adminRespondToAuthChallengeRequest.getChallengeResponses() != null) {
                Map<String, String> challengeResponses = adminRespondToAuthChallengeRequest.getChallengeResponses();
                jsonWriter.name("ChallengeResponses");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> challengeResponsesEntry : challengeResponses.entrySet()) {
                    String challengeResponsesValue = challengeResponsesEntry.getValue();
                    if (challengeResponsesValue == null) continue;
                    jsonWriter.name(challengeResponsesEntry.getKey());
                    jsonWriter.value(challengeResponsesValue);
                }
                jsonWriter.endObject();
            }
            if (adminRespondToAuthChallengeRequest.getSession() != null) {
                String session = adminRespondToAuthChallengeRequest.getSession();
                jsonWriter.name("Session");
                jsonWriter.value(session);
            }
            if (adminRespondToAuthChallengeRequest.getAnalyticsMetadata() != null) {
                AnalyticsMetadataType analyticsMetadata = adminRespondToAuthChallengeRequest.getAnalyticsMetadata();
                jsonWriter.name("AnalyticsMetadata");
                AnalyticsMetadataTypeJsonMarshaller.getInstance().marshall(analyticsMetadata, jsonWriter);
            }
            if (adminRespondToAuthChallengeRequest.getContextData() != null) {
                ContextDataType contextData = adminRespondToAuthChallengeRequest.getContextData();
                jsonWriter.name("ContextData");
                ContextDataTypeJsonMarshaller.getInstance().marshall(contextData, jsonWriter);
            }
            if (adminRespondToAuthChallengeRequest.getClientMetadata() != null) {
                Map<String, String> clientMetadata = adminRespondToAuthChallengeRequest.getClientMetadata();
                jsonWriter.name("ClientMetadata");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> clientMetadataEntry : clientMetadata.entrySet()) {
                    String clientMetadataValue = clientMetadataEntry.getValue();
                    if (clientMetadataValue == null) continue;
                    jsonWriter.name(clientMetadataEntry.getKey());
                    jsonWriter.value(clientMetadataValue);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

