/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsConfigurationTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateUserPoolClientRequestMarshaller
implements Marshaller<Request<UpdateUserPoolClientRequest>, UpdateUserPoolClientRequest> {
    public Request<UpdateUserPoolClientRequest> marshall(UpdateUserPoolClientRequest updateUserPoolClientRequest) {
        if (updateUserPoolClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateUserPoolClientRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserPoolClientRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateUserPoolClient";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateUserPoolClientRequest.getUserPoolId() != null) {
                String userPoolId = updateUserPoolClientRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (updateUserPoolClientRequest.getClientId() != null) {
                String clientId = updateUserPoolClientRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (updateUserPoolClientRequest.getClientName() != null) {
                String clientName = updateUserPoolClientRequest.getClientName();
                jsonWriter.name("ClientName");
                jsonWriter.value(clientName);
            }
            if (updateUserPoolClientRequest.getRefreshTokenValidity() != null) {
                Integer refreshTokenValidity = updateUserPoolClientRequest.getRefreshTokenValidity();
                jsonWriter.name("RefreshTokenValidity");
                jsonWriter.value((Number)refreshTokenValidity);
            }
            if (updateUserPoolClientRequest.getReadAttributes() != null) {
                List<String> readAttributes = updateUserPoolClientRequest.getReadAttributes();
                jsonWriter.name("ReadAttributes");
                jsonWriter.beginArray();
                for (String readAttributesItem : readAttributes) {
                    if (readAttributesItem == null) continue;
                    jsonWriter.value(readAttributesItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getWriteAttributes() != null) {
                List<String> writeAttributes = updateUserPoolClientRequest.getWriteAttributes();
                jsonWriter.name("WriteAttributes");
                jsonWriter.beginArray();
                for (String writeAttributesItem : writeAttributes) {
                    if (writeAttributesItem == null) continue;
                    jsonWriter.value(writeAttributesItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getExplicitAuthFlows() != null) {
                List<String> explicitAuthFlows = updateUserPoolClientRequest.getExplicitAuthFlows();
                jsonWriter.name("ExplicitAuthFlows");
                jsonWriter.beginArray();
                for (String explicitAuthFlowsItem : explicitAuthFlows) {
                    if (explicitAuthFlowsItem == null) continue;
                    jsonWriter.value(explicitAuthFlowsItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getSupportedIdentityProviders() != null) {
                List<String> supportedIdentityProviders = updateUserPoolClientRequest.getSupportedIdentityProviders();
                jsonWriter.name("SupportedIdentityProviders");
                jsonWriter.beginArray();
                for (String supportedIdentityProvidersItem : supportedIdentityProviders) {
                    if (supportedIdentityProvidersItem == null) continue;
                    jsonWriter.value(supportedIdentityProvidersItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getCallbackURLs() != null) {
                List<String> callbackURLs = updateUserPoolClientRequest.getCallbackURLs();
                jsonWriter.name("CallbackURLs");
                jsonWriter.beginArray();
                for (String callbackURLsItem : callbackURLs) {
                    if (callbackURLsItem == null) continue;
                    jsonWriter.value(callbackURLsItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getLogoutURLs() != null) {
                List<String> logoutURLs = updateUserPoolClientRequest.getLogoutURLs();
                jsonWriter.name("LogoutURLs");
                jsonWriter.beginArray();
                for (String logoutURLsItem : logoutURLs) {
                    if (logoutURLsItem == null) continue;
                    jsonWriter.value(logoutURLsItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getDefaultRedirectURI() != null) {
                String defaultRedirectURI = updateUserPoolClientRequest.getDefaultRedirectURI();
                jsonWriter.name("DefaultRedirectURI");
                jsonWriter.value(defaultRedirectURI);
            }
            if (updateUserPoolClientRequest.getAllowedOAuthFlows() != null) {
                List<String> allowedOAuthFlows = updateUserPoolClientRequest.getAllowedOAuthFlows();
                jsonWriter.name("AllowedOAuthFlows");
                jsonWriter.beginArray();
                for (String allowedOAuthFlowsItem : allowedOAuthFlows) {
                    if (allowedOAuthFlowsItem == null) continue;
                    jsonWriter.value(allowedOAuthFlowsItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getAllowedOAuthScopes() != null) {
                List<String> allowedOAuthScopes = updateUserPoolClientRequest.getAllowedOAuthScopes();
                jsonWriter.name("AllowedOAuthScopes");
                jsonWriter.beginArray();
                for (String allowedOAuthScopesItem : allowedOAuthScopes) {
                    if (allowedOAuthScopesItem == null) continue;
                    jsonWriter.value(allowedOAuthScopesItem);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolClientRequest.getAllowedOAuthFlowsUserPoolClient() != null) {
                Boolean allowedOAuthFlowsUserPoolClient = updateUserPoolClientRequest.getAllowedOAuthFlowsUserPoolClient();
                jsonWriter.name("AllowedOAuthFlowsUserPoolClient");
                jsonWriter.value(allowedOAuthFlowsUserPoolClient.booleanValue());
            }
            if (updateUserPoolClientRequest.getAnalyticsConfiguration() != null) {
                AnalyticsConfigurationType analyticsConfiguration = updateUserPoolClientRequest.getAnalyticsConfiguration();
                jsonWriter.name("AnalyticsConfiguration");
                AnalyticsConfigurationTypeJsonMarshaller.getInstance().marshall(analyticsConfiguration, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

