/*
 * Copyright 2010-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.cognitoidentityprovider.model;

import java.io.Serializable;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Deletes the attributes for a user.
 * </p>
 */
public class DeleteUserAttributesRequest extends AmazonWebServiceRequest implements Serializable {
    /**
     * <p>
     * An array of strings representing the user attribute names you want to
     * delete.
     * </p>
     * <p>
     * For custom attributes, you must prependattach the <code>custom:</code>
     * prefix to the front of the attribute name.
     * </p>
     */
    private java.util.List<String> userAttributeNames;

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the user whose
     * attributes you want to delete.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Pattern: </b>[A-Za-z0-9-_=.]+<br/>
     */
    private String accessToken;

    /**
     * <p>
     * An array of strings representing the user attribute names you want to
     * delete.
     * </p>
     * <p>
     * For custom attributes, you must prependattach the <code>custom:</code>
     * prefix to the front of the attribute name.
     * </p>
     *
     * @return <p>
     *         An array of strings representing the user attribute names you
     *         want to delete.
     *         </p>
     *         <p>
     *         For custom attributes, you must prependattach the
     *         <code>custom:</code> prefix to the front of the attribute name.
     *         </p>
     */
    public java.util.List<String> getUserAttributeNames() {
        return userAttributeNames;
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you want to
     * delete.
     * </p>
     * <p>
     * For custom attributes, you must prependattach the <code>custom:</code>
     * prefix to the front of the attribute name.
     * </p>
     *
     * @param userAttributeNames <p>
     *            An array of strings representing the user attribute names you
     *            want to delete.
     *            </p>
     *            <p>
     *            For custom attributes, you must prependattach the
     *            <code>custom:</code> prefix to the front of the attribute
     *            name.
     *            </p>
     */
    public void setUserAttributeNames(java.util.Collection<String> userAttributeNames) {
        if (userAttributeNames == null) {
            this.userAttributeNames = null;
            return;
        }

        this.userAttributeNames = new java.util.ArrayList<String>(userAttributeNames);
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you want to
     * delete.
     * </p>
     * <p>
     * For custom attributes, you must prependattach the <code>custom:</code>
     * prefix to the front of the attribute name.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param userAttributeNames <p>
     *            An array of strings representing the user attribute names you
     *            want to delete.
     *            </p>
     *            <p>
     *            For custom attributes, you must prependattach the
     *            <code>custom:</code> prefix to the front of the attribute
     *            name.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public DeleteUserAttributesRequest withUserAttributeNames(String... userAttributeNames) {
        if (getUserAttributeNames() == null) {
            this.userAttributeNames = new java.util.ArrayList<String>(userAttributeNames.length);
        }
        for (String value : userAttributeNames) {
            this.userAttributeNames.add(value);
        }
        return this;
    }

    /**
     * <p>
     * An array of strings representing the user attribute names you want to
     * delete.
     * </p>
     * <p>
     * For custom attributes, you must prependattach the <code>custom:</code>
     * prefix to the front of the attribute name.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     *
     * @param userAttributeNames <p>
     *            An array of strings representing the user attribute names you
     *            want to delete.
     *            </p>
     *            <p>
     *            For custom attributes, you must prependattach the
     *            <code>custom:</code> prefix to the front of the attribute
     *            name.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public DeleteUserAttributesRequest withUserAttributeNames(
            java.util.Collection<String> userAttributeNames) {
        setUserAttributeNames(userAttributeNames);
        return this;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the user whose
     * attributes you want to delete.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Pattern: </b>[A-Za-z0-9-_=.]+<br/>
     *
     * @return <p>
     *         A valid access token that Amazon Cognito issued to the user whose
     *         attributes you want to delete.
     *         </p>
     */
    public String getAccessToken() {
        return accessToken;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the user whose
     * attributes you want to delete.
     * </p>
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Pattern: </b>[A-Za-z0-9-_=.]+<br/>
     *
     * @param accessToken <p>
     *            A valid access token that Amazon Cognito issued to the user
     *            whose attributes you want to delete.
     *            </p>
     */
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * <p>
     * A valid access token that Amazon Cognito issued to the user whose
     * attributes you want to delete.
     * </p>
     * <p>
     * Returns a reference to this object so that method calls can be chained
     * together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Pattern: </b>[A-Za-z0-9-_=.]+<br/>
     *
     * @param accessToken <p>
     *            A valid access token that Amazon Cognito issued to the user
     *            whose attributes you want to delete.
     *            </p>
     * @return A reference to this updated object so that method calls can be
     *         chained together.
     */
    public DeleteUserAttributesRequest withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getUserAttributeNames() != null)
            sb.append("UserAttributeNames: " + getUserAttributeNames() + ",");
        if (getAccessToken() != null)
            sb.append("AccessToken: " + getAccessToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getUserAttributeNames() == null) ? 0 : getUserAttributeNames().hashCode());
        hashCode = prime * hashCode
                + ((getAccessToken() == null) ? 0 : getAccessToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteUserAttributesRequest == false)
            return false;
        DeleteUserAttributesRequest other = (DeleteUserAttributesRequest) obj;

        if (other.getUserAttributeNames() == null ^ this.getUserAttributeNames() == null)
            return false;
        if (other.getUserAttributeNames() != null
                && other.getUserAttributeNames().equals(this.getUserAttributeNames()) == false)
            return false;
        if (other.getAccessToken() == null ^ this.getAccessToken() == null)
            return false;
        if (other.getAccessToken() != null
                && other.getAccessToken().equals(this.getAccessToken()) == false)
            return false;
        return true;
    }
}
