/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsMetadataTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ResendConfirmationCodeRequestMarshaller
implements Marshaller<Request<ResendConfirmationCodeRequest>, ResendConfirmationCodeRequest> {
    public Request<ResendConfirmationCodeRequest> marshall(ResendConfirmationCodeRequest resendConfirmationCodeRequest) {
        if (resendConfirmationCodeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ResendConfirmationCodeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resendConfirmationCodeRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.ResendConfirmationCode";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (resendConfirmationCodeRequest.getClientId() != null) {
                String clientId = resendConfirmationCodeRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (resendConfirmationCodeRequest.getSecretHash() != null) {
                String secretHash = resendConfirmationCodeRequest.getSecretHash();
                jsonWriter.name("SecretHash");
                jsonWriter.value(secretHash);
            }
            if (resendConfirmationCodeRequest.getUsername() != null) {
                String username = resendConfirmationCodeRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (resendConfirmationCodeRequest.getAnalyticsMetadata() != null) {
                AnalyticsMetadataType analyticsMetadata = resendConfirmationCodeRequest.getAnalyticsMetadata();
                jsonWriter.name("AnalyticsMetadata");
                AnalyticsMetadataTypeJsonMarshaller.getInstance().marshall(analyticsMetadata, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

