/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.services.cognitoidentityprovider.model.DeviceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDevicesResult
implements Serializable {
    private List<DeviceType> devices;
    private String paginationToken;

    public List<DeviceType> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<DeviceType> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<DeviceType>(devices);
    }

    public ListDevicesResult withDevices(DeviceType ... devices) {
        if (this.getDevices() == null) {
            this.devices = new ArrayList<DeviceType>(devices.length);
        }
        for (DeviceType value : devices) {
            this.devices.add(value);
        }
        return this;
    }

    public ListDevicesResult withDevices(Collection<DeviceType> devices) {
        this.setDevices(devices);
        return this;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public ListDevicesResult withPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDevices() != null) {
            sb.append("Devices: " + this.getDevices() + ",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: " + this.getPaginationToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesResult)) {
            return false;
        }
        ListDevicesResult other = (ListDevicesResult)obj;
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        return other.getPaginationToken() == null || other.getPaginationToken().equals(this.getPaginationToken());
    }
}

