/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AdminSetUserSettingsRequest;
import com.amazonaws.services.cognitoidentityprovider.model.MFAOptionType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.MFAOptionTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class AdminSetUserSettingsRequestMarshaller
implements Marshaller<Request<AdminSetUserSettingsRequest>, AdminSetUserSettingsRequest> {
    public Request<AdminSetUserSettingsRequest> marshall(AdminSetUserSettingsRequest adminSetUserSettingsRequest) {
        if (adminSetUserSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AdminSetUserSettingsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)adminSetUserSettingsRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.AdminSetUserSettings";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (adminSetUserSettingsRequest.getUserPoolId() != null) {
                String userPoolId = adminSetUserSettingsRequest.getUserPoolId();
                jsonWriter.name("UserPoolId");
                jsonWriter.value(userPoolId);
            }
            if (adminSetUserSettingsRequest.getUsername() != null) {
                String username = adminSetUserSettingsRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (adminSetUserSettingsRequest.getMFAOptions() != null) {
                List<MFAOptionType> mFAOptions = adminSetUserSettingsRequest.getMFAOptions();
                jsonWriter.name("MFAOptions");
                jsonWriter.beginArray();
                for (MFAOptionType mFAOptionsItem : mFAOptions) {
                    if (mFAOptionsItem == null) continue;
                    MFAOptionTypeJsonMarshaller.getInstance().marshall(mFAOptionsItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

