/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.MFAOptionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetUserResult
implements Serializable {
    private String username;
    private List<AttributeType> userAttributes;
    private List<MFAOptionType> mFAOptions;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public GetUserResult withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public GetUserResult withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.userAttributes = new ArrayList<AttributeType>(userAttributes.length);
        }
        for (AttributeType value : userAttributes) {
            this.userAttributes.add(value);
        }
        return this;
    }

    public GetUserResult withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public List<MFAOptionType> getMFAOptions() {
        return this.mFAOptions;
    }

    public void setMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
            return;
        }
        this.mFAOptions = new ArrayList<MFAOptionType>(mFAOptions);
    }

    public GetUserResult withMFAOptions(MFAOptionType ... mFAOptions) {
        if (this.getMFAOptions() == null) {
            this.mFAOptions = new ArrayList<MFAOptionType>(mFAOptions.length);
        }
        for (MFAOptionType value : mFAOptions) {
            this.mFAOptions.add(value);
        }
        return this;
    }

    public GetUserResult withMFAOptions(Collection<MFAOptionType> mFAOptions) {
        this.setMFAOptions(mFAOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getMFAOptions() != null) {
            sb.append("MFAOptions: " + this.getMFAOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMFAOptions() == null ? 0 : this.getMFAOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResult)) {
            return false;
        }
        GetUserResult other = (GetUserResult)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getMFAOptions() == null ^ this.getMFAOptions() == null) {
            return false;
        }
        return other.getMFAOptions() == null || other.getMFAOptions().equals(this.getMFAOptions());
    }
}

