/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.SignUpHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoSecretHash;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.SignUpRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SignUpResult;
import java.util.ArrayList;
import java.util.Map;

public class CognitoUserPool {
    private final String userPoolId;
    private final String clientId;
    private final String clientSecret;
    private final Context context;
    private final AmazonCognitoIdentityProvider client;
    private String secretHash;

    @Deprecated
    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, ClientConfiguration clientConfiguration) {
        this(context, userPoolId, clientId, clientSecret, clientConfiguration, Regions.US_EAST_1);
    }

    @Deprecated
    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret) {
        this(context, userPoolId, clientId, clientSecret, new ClientConfiguration(), Regions.US_EAST_1);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, Regions region) {
        this(context, userPoolId, clientId, clientSecret, new ClientConfiguration(), region);
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, ClientConfiguration clientConfiguration, Regions region) {
        this.context = context;
        this.userPoolId = userPoolId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.client = new AmazonCognitoIdentityProviderClient((AWSCredentials)new AnonymousAWSCredentials(), clientConfiguration);
        this.client.setRegion(Region.getRegion((Regions)region));
    }

    public CognitoUserPool(Context context, String userPoolId, String clientId, String clientSecret, AmazonCognitoIdentityProvider client) {
        this.context = context;
        this.userPoolId = userPoolId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.client = client;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void signUpInBackground(final String userId, final String password, final CognitoUserAttributes userAttributes, final Map<String, String> validationData, final SignUpHandler callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUserPool.this.context.getMainLooper());
                try {
                    final SignUpResult signUpResult = CognitoUserPool.this.signUpInternal(userId, password, userAttributes, validationData);
                    final CognitoUser user = CognitoUserPool.this.getUser(userId);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(user, signUpResult.getUserConfirmed(), new CognitoUserCodeDeliveryDetails(signUpResult.getCodeDeliveryDetails()));
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void signUp(String userId, String password, CognitoUserAttributes userAttributes, Map<String, String> validationData, SignUpHandler callback) {
        try {
            SignUpResult signUpResult = this.signUpInternal(userId, password, userAttributes, validationData);
            CognitoUser user = this.getUser(userId);
            callback.onSuccess(user, signUpResult.getUserConfirmed(), new CognitoUserCodeDeliveryDetails(signUpResult.getCodeDeliveryDetails()));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private SignUpResult signUpInternal(String userId, String password, CognitoUserAttributes userAttributes, Map<String, String> validationData) {
        ArrayList<AttributeType> validationDataList = null;
        if (validationData != null) {
            validationDataList = new ArrayList<AttributeType>();
            for (Map.Entry<String, String> data : validationData.entrySet()) {
                AttributeType validation = new AttributeType();
                validation.setName(data.getKey());
                validation.setValue(data.getValue());
                validationDataList.add(validation);
            }
        }
        this.secretHash = CognitoSecretHash.getSecretHash(userId, this.clientId, this.clientSecret);
        SignUpRequest signUpUserRequest = new SignUpRequest();
        signUpUserRequest.setUsername(userId);
        signUpUserRequest.setPassword(password);
        signUpUserRequest.setClientId(this.clientId);
        signUpUserRequest.setSecretHash(this.secretHash);
        signUpUserRequest.setUserAttributes(userAttributes.getAttributesList());
        signUpUserRequest.setValidationData(validationDataList);
        return this.client.signUp(signUpUserRequest);
    }

    public CognitoUser getCurrentUser() {
        String csiLastUserKey;
        SharedPreferences csiCachedTokens = this.context.getSharedPreferences("CognitoIdentityProviderCache", 0);
        if (csiCachedTokens.contains(csiLastUserKey = "CognitoIdentityProvider." + this.clientId + ".LastAuthUser")) {
            return this.getUser(csiCachedTokens.getString(csiLastUserKey, null));
        }
        return this.getUser();
    }

    public CognitoUser getUser() {
        return new CognitoUser(this, null, this.clientId, this.clientSecret, null, this.client, this.context);
    }

    public CognitoUser getUser(String userId) {
        if (userId == null) {
            return this.getUser();
        }
        if (userId.isEmpty()) {
            return this.getUser();
        }
        return new CognitoUser(this, userId, this.clientId, this.clientSecret, CognitoSecretHash.getSecretHash(userId, this.clientId, this.clientSecret), this.client, this.context);
    }
}

