/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class NewPasswordContinuation
extends ChallengeContinuation {
    private List<String> requiredAttributes;
    private Map<String, String> currentUserAttributes;
    private final AuthenticationHandler callback;

    public NewPasswordContinuation(CognitoUser user, Context context, String username, String clientId, String secretHash, RespondToAuthChallengeResult challengeResult, boolean runInBackground, AuthenticationHandler callback) {
        super(user, context, username, clientId, secretHash, challengeResult, runInBackground, callback);
        this.callback = callback;
        this.parseUserAttributes((String)this.getParameters().get("userAttributes"));
        this.parseRequiredAttributes((String)this.getParameters().get("requiredAttributes"));
    }

    public List<String> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public Map<String, String> getCurrentUserAttributes() {
        return this.currentUserAttributes;
    }

    public void setUserAttribute(String attributeName, String attributeValue) {
        this.setChallengeResponse("userAttributes." + attributeName, attributeValue);
    }

    public void setPassword(String userPassword) {
        if (userPassword != null) {
            this.setChallengeResponse("NEW_PASSWORD", userPassword);
        }
    }

    @Override
    public void continueTask() {
        if (this.requiredAttributes != null && this.requiredAttributes.size() > 1) {
            for (String requiredAttribute : this.requiredAttributes) {
                String requiredAttrKey = "userAttributes." + requiredAttribute;
                if (this.challengeResponses.containsKey(requiredAttrKey)) continue;
                throw new CognitoParameterInvalidException(String.format("Missing required attribute: %s", requiredAttribute));
            }
        }
        if (!this.challengeResponses.containsKey("NEW_PASSWORD") || this.challengeResponses.get("NEW_PASSWORD") == null) {
            throw new CognitoParameterInvalidException("New password was not set");
        }
        super.continueTask();
    }

    private void parseUserAttributes(String userAttributesJsonString) {
        this.currentUserAttributes = new HashMap<String, String>();
        if (userAttributesJsonString != null) {
            try {
                JSONObject userAttributesJson = new JSONObject(userAttributesJsonString);
                Iterator userAttribute = userAttributesJson.keys();
                while (userAttribute.hasNext()) {
                    String attributeName = (String)userAttribute.next();
                    String attributeValue = userAttributesJson.getString(attributeName);
                    this.currentUserAttributes.put(attributeName, attributeValue);
                }
            }
            catch (Exception e) {
                this.callback.onFailure(e);
            }
        }
    }

    private void parseRequiredAttributes(String requiredAttributesJsonString) {
        this.requiredAttributes = new ArrayList<String>();
        if (requiredAttributesJsonString != null) {
            try {
                JSONArray requiredAttributesJson = new JSONArray(requiredAttributesJsonString);
                for (int i = 0; i < requiredAttributesJson.length(); ++i) {
                    this.requiredAttributes.add(requiredAttributesJson.getString(i).split("userAttributes.", 2)[1]);
                }
            }
            catch (Exception e) {
                this.callback.onFailure(e);
            }
        }
    }
}

