/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class VerifyUserAttributeRequestMarshaller
implements Marshaller<Request<VerifyUserAttributeRequest>, VerifyUserAttributeRequest> {
    public Request<VerifyUserAttributeRequest> marshall(VerifyUserAttributeRequest verifyUserAttributeRequest) {
        if (verifyUserAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(VerifyUserAttributeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)verifyUserAttributeRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.VerifyUserAttribute";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (verifyUserAttributeRequest.getAccessToken() != null) {
                String accessToken = verifyUserAttributeRequest.getAccessToken();
                jsonWriter.name("AccessToken");
                jsonWriter.value(accessToken);
            }
            if (verifyUserAttributeRequest.getAttributeName() != null) {
                String attributeName = verifyUserAttributeRequest.getAttributeName();
                jsonWriter.name("AttributeName");
                jsonWriter.value(attributeName);
            }
            if (verifyUserAttributeRequest.getCode() != null) {
                String code = verifyUserAttributeRequest.getCode();
                jsonWriter.name("Code");
                jsonWriter.value(code);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

