/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import android.content.Context;
import android.os.Handler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoInternalErrorException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoNotAuthorizedException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceType;
import com.amazonaws.services.cognitoidentityprovider.model.ForgetDeviceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetDeviceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetDeviceResult;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateDeviceStatusRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateDeviceStatusResult;
import java.util.Date;

public class CognitoDevice {
    private final String DEVICE_NAME_ATTRIBUTE = "device_name";
    private final String DEVICE_TYPE_REMEMBERED = "remembered";
    private final String DEVICE_TYPE_NOT_REMEMBERED = "not_remembered";
    private final String deviceKey;
    private CognitoUserAttributes deviceAttributes;
    private final Date createDate;
    private Date lastModifiedDate;
    private Date lastAccessedDate;
    private final CognitoUser user;
    private final Context context;

    public CognitoDevice(String deviceKey, CognitoUserAttributes deviceAttributes, Date createDate, Date lastModifiedDate, Date lastAccessedDate, CognitoUser user, Context context) {
        this.deviceKey = deviceKey;
        this.deviceAttributes = deviceAttributes;
        this.createDate = createDate;
        this.lastModifiedDate = lastModifiedDate;
        this.lastAccessedDate = lastAccessedDate;
        this.user = user;
        this.context = context;
    }

    public CognitoDevice(DeviceType device, CognitoUser user, Context context) {
        this.deviceKey = device.getDeviceKey();
        this.deviceAttributes = new CognitoUserAttributes(device.getDeviceAttributes());
        this.createDate = device.getDeviceCreateDate();
        this.lastModifiedDate = device.getDeviceLastModifiedDate();
        this.lastAccessedDate = device.getDeviceLastModifiedDate();
        this.user = user;
        this.context = context;
    }

    public String getDeviceKey() {
        return this.deviceKey;
    }

    public CognitoUserAttributes getDeviceAttributes() {
        return this.deviceAttributes;
    }

    public String getDeviceAttribute(String attributeName) {
        try {
            return this.deviceAttributes.getAttributes().get(attributeName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDeviceName() {
        return this.getDeviceAttribute("device_name");
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Date getLastAccessedDate() {
        return this.lastAccessedDate;
    }

    public void getDeviceInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoDevice.this.context.getMainLooper());
                try {
                    GetDeviceResult getDeviceResult = CognitoDevice.this.getDeviceInternal(CognitoDevice.this.user.getCachedSession());
                    CognitoDevice.this.updateThis(getDeviceResult.getDevice());
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getDevice(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            GetDeviceResult getDeviceResult = this.getDeviceInternal(this.user.getCachedSession());
            this.updateThis(getDeviceResult.getDevice());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public void forgetDeviceInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoDevice.this.context.getMainLooper());
                try {
                    CognitoDevice.this.forgetDeviceInternal(CognitoDevice.this.user.getCachedSession());
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void forgetDevice(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.forgetDeviceInternal(this.user.getCachedSession());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public void rememberThisDeviceInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoDevice.this.context.getMainLooper());
                try {
                    CognitoDevice.this.updateDeviceStatusInternal(CognitoDevice.this.user.getCachedSession(), "remembered");
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void rememberThisDevice(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.updateDeviceStatusInternal(this.user.getCachedSession(), "remembered");
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public void doNotRememberThisDeviceInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoDevice.this.context.getMainLooper());
                try {
                    CognitoDevice.this.updateDeviceStatusInternal(CognitoDevice.this.user.getCachedSession(), "not_remembered");
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void doNotRememberThisDevice(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.updateDeviceStatusInternal(this.user.getCachedSession(), "not_remembered");
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forgetDeviceInternal(CognitoUserSession session) {
        if (session == null || !session.isValid()) throw new CognitoNotAuthorizedException("User is not authorized");
        if (this.deviceKey == null) throw new CognitoParameterInvalidException("Device key is null");
        CognitoDevice currentDeviceKey = this.user.thisDevice();
        if (this.deviceKey.equals(currentDeviceKey.getDeviceKey())) {
            // empty if block
        }
        ForgetDeviceRequest forgetDeviceRequest = new ForgetDeviceRequest();
        forgetDeviceRequest.setAccessToken(session.getAccessToken().getJWTToken());
        forgetDeviceRequest.setDeviceKey(this.deviceKey);
        this.user.getCognitoIdentityProviderClient().forgetDevice(forgetDeviceRequest);
    }

    private GetDeviceResult getDeviceInternal(CognitoUserSession session) {
        if (session != null && session.isValid()) {
            if (this.deviceKey != null) {
                GetDeviceRequest getDeviceRequest = new GetDeviceRequest();
                getDeviceRequest.setAccessToken(session.getAccessToken().getJWTToken());
                getDeviceRequest.setDeviceKey(this.deviceKey);
                return this.user.getCognitoIdentityProviderClient().getDevice(getDeviceRequest);
            }
            throw new CognitoParameterInvalidException("Device key is null");
        }
        throw new CognitoNotAuthorizedException("User is not authorized");
    }

    private UpdateDeviceStatusResult updateDeviceStatusInternal(CognitoUserSession session, String deviceTrustState) {
        if (session != null && session.isValid()) {
            if (this.deviceKey != null) {
                UpdateDeviceStatusRequest updateDeviceStatusRequest = new UpdateDeviceStatusRequest();
                updateDeviceStatusRequest.setAccessToken(session.getAccessToken().getJWTToken());
                updateDeviceStatusRequest.setDeviceKey(this.deviceKey);
                updateDeviceStatusRequest.setDeviceRememberedStatus(deviceTrustState);
                return this.user.getCognitoIdentityProviderClient().updateDeviceStatus(updateDeviceStatusRequest);
            }
            throw new CognitoParameterInvalidException("Device key is invalid");
        }
        throw new CognitoNotAuthorizedException("User is not authorized");
    }

    private void updateThis(DeviceType device) {
        if (device == null) {
            throw new CognitoInternalErrorException("Service returned null object, this object was not updated");
        }
        if (!device.getDeviceKey().equals(this.deviceKey)) {
            throw new CognitoInternalErrorException("Service error, this object was not updated");
        }
        this.deviceAttributes = new CognitoUserAttributes(device.getDeviceAttributes());
        this.lastModifiedDate = device.getDeviceLastModifiedDate();
        this.lastAccessedDate = device.getDeviceLastModifiedDate();
    }
}

