/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class RespondToAuthChallengeRequestMarshaller
implements Marshaller<Request<RespondToAuthChallengeRequest>, RespondToAuthChallengeRequest> {
    public Request<RespondToAuthChallengeRequest> marshall(RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        if (respondToAuthChallengeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RespondToAuthChallengeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)respondToAuthChallengeRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.RespondToAuthChallenge";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (respondToAuthChallengeRequest.getClientId() != null) {
                String clientId = respondToAuthChallengeRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (respondToAuthChallengeRequest.getChallengeName() != null) {
                String challengeName = respondToAuthChallengeRequest.getChallengeName();
                jsonWriter.name("ChallengeName");
                jsonWriter.value(challengeName);
            }
            if (respondToAuthChallengeRequest.getSession() != null) {
                String session = respondToAuthChallengeRequest.getSession();
                jsonWriter.name("Session");
                jsonWriter.value(session);
            }
            if (respondToAuthChallengeRequest.getChallengeResponses() != null) {
                Map<String, String> challengeResponses = respondToAuthChallengeRequest.getChallengeResponses();
                jsonWriter.name("ChallengeResponses");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> challengeResponsesEntry : challengeResponses.entrySet()) {
                    String challengeResponsesValue = challengeResponsesEntry.getValue();
                    if (challengeResponsesValue == null) continue;
                    jsonWriter.name(challengeResponsesEntry.getKey());
                    jsonWriter.value(challengeResponsesValue);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

