/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.GetOpenIdConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetOpenIdConfigurationRequestMarshaller
implements Marshaller<Request<GetOpenIdConfigurationRequest>, GetOpenIdConfigurationRequest> {
    public Request<GetOpenIdConfigurationRequest> marshall(GetOpenIdConfigurationRequest getOpenIdConfigurationRequest) {
        if (getOpenIdConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetOpenIdConfigurationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getOpenIdConfigurationRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.GetOpenIdConfiguration";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{userPoolId}/.well-known/openid-configuration";
        uriResourcePath = uriResourcePath.replace("{userPoolId}", getOpenIdConfigurationRequest.getUserPoolId() == null ? "" : StringUtils.fromString((String)getOpenIdConfigurationRequest.getUserPoolId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

