/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.GetAuthenticationDetailsRequest;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class GetAuthenticationDetailsRequestMarshaller
implements Marshaller<Request<GetAuthenticationDetailsRequest>, GetAuthenticationDetailsRequest> {
    public Request<GetAuthenticationDetailsRequest> marshall(GetAuthenticationDetailsRequest getAuthenticationDetailsRequest) {
        if (getAuthenticationDetailsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetAuthenticationDetailsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAuthenticationDetailsRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.GetAuthenticationDetails";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (getAuthenticationDetailsRequest.getClientId() != null) {
                String clientId = getAuthenticationDetailsRequest.getClientId();
                jsonWriter.name("ClientId");
                jsonWriter.value(clientId);
            }
            if (getAuthenticationDetailsRequest.getSecretHash() != null) {
                String secretHash = getAuthenticationDetailsRequest.getSecretHash();
                jsonWriter.name("SecretHash");
                jsonWriter.value(secretHash);
            }
            if (getAuthenticationDetailsRequest.getUsername() != null) {
                String username = getAuthenticationDetailsRequest.getUsername();
                jsonWriter.name("Username");
                jsonWriter.value(username);
            }
            if (getAuthenticationDetailsRequest.getSrpA() != null) {
                String srpA = getAuthenticationDetailsRequest.getSrpA();
                jsonWriter.name("SrpA");
                jsonWriter.value(srpA);
            }
            if (getAuthenticationDetailsRequest.getValidationData() != null) {
                List<AttributeType> validationData = getAuthenticationDetailsRequest.getValidationData();
                jsonWriter.name("ValidationData");
                jsonWriter.beginArray();
                for (AttributeType validationDataItem : validationData) {
                    if (validationDataItem == null) continue;
                    AttributeTypeJsonMarshaller.getInstance().marshall(validationDataItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

