/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoDevice;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoMfaSettings;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSettings;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChooseMfaContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ForgotPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.MultiFactorAuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.NewPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.RegisterMfaContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.VerifyMfaContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoInternalErrorException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoNotAuthorizedException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.DevicesHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GetDetailsHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.RegisterMfaHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.UpdateAttributesHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.VerificationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoAccessToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoIdToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoRefreshToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoDeviceHelper;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoJWTParser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoSecretHash;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.Hkdf;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider;
import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.AssociateSoftwareTokenRequest;
import com.amazonaws.services.cognitoidentityprovider.model.AssociateSoftwareTokenResult;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.AuthenticationResultType;
import com.amazonaws.services.cognitoidentityprovider.model.ChangePasswordRequest;
import com.amazonaws.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmDeviceResult;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmForgotPasswordRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ConfirmSignUpRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeleteUserAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeleteUserRequest;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceSecretVerifierConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.DeviceType;
import com.amazonaws.services.cognitoidentityprovider.model.ForgotPasswordRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ForgotPasswordResult;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserAttributeVerificationCodeResult;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserRequest;
import com.amazonaws.services.cognitoidentityprovider.model.GetUserResult;
import com.amazonaws.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import com.amazonaws.services.cognitoidentityprovider.model.InitiateAuthRequest;
import com.amazonaws.services.cognitoidentityprovider.model.InitiateAuthResult;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidParameterException;
import com.amazonaws.services.cognitoidentityprovider.model.ListDevicesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ListDevicesResult;
import com.amazonaws.services.cognitoidentityprovider.model.NewDeviceMetadataType;
import com.amazonaws.services.cognitoidentityprovider.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidentityprovider.model.ResendConfirmationCodeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ResendConfirmationCodeResult;
import com.amazonaws.services.cognitoidentityprovider.model.ResourceNotFoundException;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;
import com.amazonaws.services.cognitoidentityprovider.model.RevokeTokenRequest;
import com.amazonaws.services.cognitoidentityprovider.model.RevokeTokenResult;
import com.amazonaws.services.cognitoidentityprovider.model.SMSMfaSettingsType;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserMFAPreferenceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserMFAPreferenceResult;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserSettingsRequest;
import com.amazonaws.services.cognitoidentityprovider.model.SetUserSettingsResult;
import com.amazonaws.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserAttributesResult;
import com.amazonaws.services.cognitoidentityprovider.model.UserContextDataType;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotFoundException;
import com.amazonaws.services.cognitoidentityprovider.model.VerifySoftwareTokenRequest;
import com.amazonaws.services.cognitoidentityprovider.model.VerifySoftwareTokenResponseType;
import com.amazonaws.services.cognitoidentityprovider.model.VerifySoftwareTokenResult;
import com.amazonaws.services.cognitoidentityprovider.model.VerifyUserAttributeRequest;
import com.amazonaws.services.cognitoidentityprovider.model.VerifyUserAttributeResult;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CognitoUser {
    private static final Log LOGGER = LogFactory.getLog(CognitoUser.class);
    private static final int SRP_RADIX = 16;
    private final Context context;
    private final AmazonCognitoIdentityProvider cognitoIdentityProviderClient;
    private final String clientId;
    private final String clientSecret;
    private String userId;
    private String usernameInternal;
    private String deviceKey;
    private final CognitoUserPool pool;
    private String secretHash;
    private CognitoUserSession cipSession;
    private static final Object GET_CACHED_SESSION_LOCK = new Object();

    protected CognitoUser(CognitoUserPool pool, String userId, String clientId, String clientSecret, String secretHash, AmazonCognitoIdentityProvider client, Context context) {
        this.pool = pool;
        this.context = context;
        this.userId = userId;
        this.cognitoIdentityProviderClient = client;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.secretHash = secretHash;
        this.deviceKey = null;
        this.cipSession = null;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserPoolId() {
        return this.pool.getUserPoolId();
    }

    protected AmazonCognitoIdentityProvider getCognitoIdentityProviderClient() {
        return this.cognitoIdentityProviderClient;
    }

    public void confirmSignUpInBackground(String confirmationCode, boolean forcedAliasCreation, GenericHandler callback) {
        this.confirmSignUpInBackground(confirmationCode, forcedAliasCreation, Collections.emptyMap(), callback);
    }

    public void confirmSignUp(String confirmationCode, boolean forcedAliasCreation, GenericHandler callback) {
        this.confirmSignUp(confirmationCode, forcedAliasCreation, Collections.emptyMap(), callback);
    }

    public void confirmSignUpInBackground(final String confirmationCode, final boolean forcedAliasCreation, final Map<String, String> clientMetadata, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.confirmSignUpInternal(confirmationCode, forcedAliasCreation, clientMetadata);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void confirmSignUp(String confirmationCode, boolean forcedAliasCreation, Map<String, String> clientMetadata, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.confirmSignUpInternal(confirmationCode, forcedAliasCreation, clientMetadata);
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void confirmSignUpInternal(String confirmationCode, boolean forcedAliasCreation, Map<String, String> clientMetadata) {
        ConfirmSignUpRequest confirmUserRegistrationRequest = new ConfirmSignUpRequest().withClientId(this.clientId).withSecretHash(this.secretHash).withUsername(this.userId).withConfirmationCode(confirmationCode).withForceAliasCreation(forcedAliasCreation).withClientMetadata(clientMetadata).withUserContextData(this.getUserContextData());
        String pinpointEndpointId = this.pool.getPinpointEndpointId();
        if (pinpointEndpointId != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            confirmUserRegistrationRequest.setAnalyticsMetadata(amd);
        }
        this.cognitoIdentityProviderClient.confirmSignUp(confirmUserRegistrationRequest);
    }

    public void resendConfirmationCodeInBackground(VerificationHandler callback) {
        this.resendConfirmationCodeInBackground(Collections.emptyMap(), callback);
    }

    public void resendConfirmationCodeInBackground(final Map<String, String> clientMetadata, final VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    final ResendConfirmationCodeResult resendConfirmationCodeResult = CognitoUser.this.resendConfirmationCodeInternal(clientMetadata);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(new CognitoUserCodeDeliveryDetails(resendConfirmationCodeResult.getCodeDeliveryDetails()));
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void resendConfirmationCode(VerificationHandler callback) {
        this.resendConfirmationCode(Collections.emptyMap(), callback);
    }

    public void resendConfirmationCode(Map<String, String> clientMetadata, VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            ResendConfirmationCodeResult resendConfirmationCodeResult = this.resendConfirmationCodeInternal(clientMetadata);
            callback.onSuccess(new CognitoUserCodeDeliveryDetails(resendConfirmationCodeResult.getCodeDeliveryDetails()));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private ResendConfirmationCodeResult resendConfirmationCodeInternal(Map<String, String> clientMetadata) {
        ResendConfirmationCodeRequest resendConfirmationCodeRequest = new ResendConfirmationCodeRequest().withUsername(this.userId).withClientId(this.clientId).withSecretHash(this.secretHash).withClientMetadata(clientMetadata);
        String pinpointEndpointId = this.pool.getPinpointEndpointId();
        resendConfirmationCodeRequest.setUserContextData(this.getUserContextData());
        if (pinpointEndpointId != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            resendConfirmationCodeRequest.setAnalyticsMetadata(amd);
        }
        return this.cognitoIdentityProviderClient.resendConfirmationCode(resendConfirmationCodeRequest);
    }

    public void forgotPasswordInBackground(ForgotPasswordHandler callback) {
        this.forgotPasswordInBackground(Collections.emptyMap(), callback);
    }

    public void forgotPassword(ForgotPasswordHandler callback) {
        this.forgotPassword(Collections.emptyMap(), callback);
    }

    public void forgotPasswordInBackground(final Map<String, String> clientMetadata, final ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser cognitoUser = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    ForgotPasswordResult forgotPasswordResult = CognitoUser.this.forgotPasswordInternal(clientMetadata);
                    final ForgotPasswordContinuation continuation = new ForgotPasswordContinuation(cognitoUser, new CognitoUserCodeDeliveryDetails(forgotPasswordResult.getCodeDeliveryDetails()), true, callback);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.getResetCode(continuation);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void forgotPassword(Map<String, String> clientMetadata, ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        CognitoUser cognitoUser = this;
        try {
            ForgotPasswordResult forgotPasswordResult = this.forgotPasswordInternal(clientMetadata);
            ForgotPasswordContinuation continuation = new ForgotPasswordContinuation(cognitoUser, new CognitoUserCodeDeliveryDetails(forgotPasswordResult.getCodeDeliveryDetails()), false, callback);
            callback.getResetCode(continuation);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private ForgotPasswordResult forgotPasswordInternal(Map<String, String> clientMetadata) {
        ForgotPasswordRequest resetPasswordRequest = new ForgotPasswordRequest();
        resetPasswordRequest.setClientId(this.clientId);
        resetPasswordRequest.setSecretHash(this.secretHash);
        resetPasswordRequest.setUsername(this.userId);
        resetPasswordRequest.setUserContextData(this.getUserContextData());
        resetPasswordRequest.setClientMetadata(clientMetadata);
        String pinpointEndpointId = this.pool.getPinpointEndpointId();
        if (pinpointEndpointId != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            resetPasswordRequest.setAnalyticsMetadata(amd);
        }
        return this.cognitoIdentityProviderClient.forgotPassword(resetPasswordRequest);
    }

    public void confirmPasswordInBackground(String verificationCode, String newPassword, ForgotPasswordHandler callback) {
        this.confirmPasswordInBackground(verificationCode, newPassword, Collections.emptyMap(), callback);
    }

    public void confirmPasswordInBackground(final String verificationCode, final String newPassword, final Map<String, String> clientMetadata, final ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.confirmPasswordInternal(verificationCode, newPassword, clientMetadata);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void confirmPassword(String verificationCode, String newPassword, ForgotPasswordHandler callback) {
        this.confirmPassword(verificationCode, newPassword, Collections.emptyMap(), callback);
    }

    public void confirmPassword(String verificationCode, String newPassword, Map<String, String> clientMetadata, ForgotPasswordHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.confirmPasswordInternal(verificationCode, newPassword, clientMetadata);
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void confirmPasswordInternal(String verificationCode, String newPassword, Map<String, String> clientMetadata) {
        ConfirmForgotPasswordRequest confirmResetPasswordRequest = new ConfirmForgotPasswordRequest();
        confirmResetPasswordRequest.setUsername(this.userId);
        confirmResetPasswordRequest.setClientId(this.clientId);
        confirmResetPasswordRequest.setSecretHash(this.secretHash);
        confirmResetPasswordRequest.setConfirmationCode(verificationCode);
        confirmResetPasswordRequest.setPassword(newPassword);
        confirmResetPasswordRequest.setUserContextData(this.getUserContextData());
        confirmResetPasswordRequest.setClientMetadata(clientMetadata);
        String pinpointEndpointId = this.pool.getPinpointEndpointId();
        if (pinpointEndpointId != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            confirmResetPasswordRequest.setAnalyticsMetadata(amd);
        }
        this.cognitoIdentityProviderClient.confirmForgotPassword(confirmResetPasswordRequest);
    }

    public void getSessionInBackground(final AuthenticationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser cognitoUser = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.getCachedSession();
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(CognitoUser.this.cipSession, null);
                        }
                    };
                }
                catch (CognitoNotAuthorizedException e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(cognitoUser, CognitoUser.this.context, true, callback);
                            callback.getAuthenticationDetails(authenticationContinuation, cognitoUser.getUserId());
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getSession(AuthenticationHandler callback) {
        this.getSession(Collections.emptyMap(), callback);
    }

    public void getSession(Map<String, String> clientMetadata, AuthenticationHandler callback) {
        if (callback == null) {
            throw new InvalidParameterException("callback is null");
        }
        try {
            this.getCachedSession();
            callback.onSuccess(this.cipSession, null);
        }
        catch (InvalidParameterException e) {
            callback.onFailure((Exception)((Object)e));
        }
        catch (CognitoNotAuthorizedException e) {
            AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(this, this.context, false, callback);
            authenticationContinuation.setClientMetaData(clientMetadata);
            callback.getAuthenticationDetails(authenticationContinuation, this.getUserId());
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public Runnable initiateUserAuthentication(AuthenticationDetails authenticationDetails, AuthenticationHandler callback, boolean runInBackground) {
        return this.initiateUserAuthentication(Collections.emptyMap(), authenticationDetails, callback, runInBackground);
    }

    public Runnable initiateUserAuthentication(Map<String, String> clientMetadata, AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, final boolean runInBackground) {
        AuthenticationHandler internalCallback = new AuthenticationHandler(){

            @Override
            public void onSuccess(final CognitoUserSession userSession, final CognitoDevice newDevice) {
                if (runInBackground) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(userSession, newDevice);
                        }
                    });
                } else {
                    callback.onSuccess(userSession, newDevice);
                }
            }

            @Override
            public void getAuthenticationDetails(final AuthenticationContinuation authenticationContinuation, final String userId) {
                if (runInBackground) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.getAuthenticationDetails(authenticationContinuation, userId);
                        }
                    });
                } else {
                    callback.getAuthenticationDetails(authenticationContinuation, userId);
                }
            }

            @Override
            public void getMFACode(final MultiFactorAuthenticationContinuation continuation) {
                if (runInBackground) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.getMFACode(continuation);
                        }
                    });
                } else {
                    callback.getMFACode(continuation);
                }
            }

            @Override
            public void authenticationChallenge(final ChallengeContinuation continuation) {
                if (runInBackground) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.authenticationChallenge(continuation);
                        }
                    });
                } else {
                    callback.authenticationChallenge(continuation);
                }
            }

            @Override
            public void onFailure(final Exception exception) {
                if (runInBackground) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(exception);
                        }
                    });
                } else {
                    callback.onFailure(exception);
                }
            }
        };
        final Runnable task = this._initiateUserAuthentication(clientMetadata, authenticationDetails, internalCallback, runInBackground);
        if (runInBackground) {
            return new Runnable(){

                @Override
                public void run() {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            task.run();
                        }
                    }).start();
                }
            };
        }
        return task;
    }

    Runnable _initiateUserAuthentication(Map<String, String> clientMetadata, final AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, boolean runInBackground) {
        if ("PASSWORD_VERIFIER".equals(authenticationDetails.getAuthenticationType())) {
            return this.startWithUserSrpAuth(clientMetadata, authenticationDetails, callback, runInBackground);
        }
        if ("CUSTOM_CHALLENGE".equals(authenticationDetails.getAuthenticationType())) {
            return this.startWithCustomAuth(clientMetadata, authenticationDetails, callback, runInBackground);
        }
        if ("USER_PASSWORD".equals(authenticationDetails.getAuthenticationType())) {
            return this.startWithUserPasswordAuth(clientMetadata, authenticationDetails, callback, runInBackground);
        }
        return new Runnable(){

            @Override
            public void run() {
                callback.onFailure((Exception)((Object)new CognitoParameterInvalidException("Unsupported authentication type " + authenticationDetails.getAuthenticationType())));
            }
        };
    }

    public Runnable respondToMfaChallenge(String mfaCode, RespondToAuthChallengeResult challenge, AuthenticationHandler callback, boolean runInBackground) {
        return this.respondToMfaChallenge(Collections.emptyMap(), mfaCode, challenge, callback, runInBackground);
    }

    public Runnable respondToMfaChallenge(Map<String, String> clientMetadata, String mfaCode, RespondToAuthChallengeResult challenge, AuthenticationHandler callback, boolean runInBackground) {
        RespondToAuthChallengeRequest challengeResponse = new RespondToAuthChallengeRequest();
        HashMap<String, String> mfaParameters = new HashMap<String, String>();
        if ("SMS_MFA".equals(challenge.getChallengeName())) {
            mfaParameters.put("SMS_MFA_CODE", mfaCode);
        } else if ("SOFTWARE_TOKEN_MFA".equals(challenge.getChallengeName())) {
            mfaParameters.put("SOFTWARE_TOKEN_MFA_CODE", mfaCode);
        }
        mfaParameters.put("USERNAME", this.usernameInternal);
        mfaParameters.put("DEVICE_KEY", this.deviceKey);
        mfaParameters.put("SECRET_HASH", this.secretHash);
        challengeResponse.setClientId(this.clientId);
        challengeResponse.setSession(challenge.getSession());
        challengeResponse.setChallengeName(challenge.getChallengeName());
        challengeResponse.setChallengeResponses(mfaParameters);
        challengeResponse.setUserContextData(this.getUserContextData());
        challengeResponse.setClientMetadata(clientMetadata);
        return this.respondToChallenge(clientMetadata, challengeResponse, callback, runInBackground);
    }

    protected CognitoUserSession getCachedSession() {
        Object object = GET_CACHED_SESSION_LOCK;
        synchronized (object) {
            if (this.userId == null) {
                throw new CognitoNotAuthorizedException("User-ID is null");
            }
            if (this.cipSession != null && this.cipSession.isValidForThreshold()) {
                return this.cipSession;
            }
            CognitoUserSession cognitoUserSessionFromStore = this.readCachedTokens();
            if (cognitoUserSessionFromStore.isValidForThreshold()) {
                this.cipSession = cognitoUserSessionFromStore;
                return this.cipSession;
            }
            if (cognitoUserSessionFromStore.getRefreshToken() != null) {
                try {
                    this.cipSession = this.refreshSession(cognitoUserSessionFromStore);
                    this.cacheTokens(this.cipSession);
                    return this.cipSession;
                }
                catch (NotAuthorizedException nae) {
                    this.clearCachedTokens();
                    throw new CognitoNotAuthorizedException("User is not authenticated", (Throwable)((Object)nae));
                }
                catch (UserNotFoundException unfe) {
                    this.clearCachedTokens();
                    throw new CognitoNotAuthorizedException("User does not exist", (Throwable)((Object)unfe));
                }
                catch (Exception e) {
                    throw new CognitoInternalErrorException("Failed to authenticate user", e);
                }
            }
            throw new CognitoNotAuthorizedException("User is not authenticated");
        }
    }

    public void changePasswordInBackground(final String oldUserPassword, final String newUserPassword, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.changePasswordInternal(oldUserPassword, newUserPassword, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void changePassword(String oldUserPassword, String newUserPassword, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.changePasswordInternal(oldUserPassword, newUserPassword, this.getCachedSession());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void changePasswordInternal(String oldUserPassword, String newUserPassword, CognitoUserSession session) {
        if (session == null || !session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest();
        changePasswordRequest.setPreviousPassword(oldUserPassword);
        changePasswordRequest.setProposedPassword(newUserPassword);
        changePasswordRequest.setAccessToken(session.getAccessToken().getJWTToken());
        this.cognitoIdentityProviderClient.changePassword(changePasswordRequest);
    }

    public void getDetailsInBackground(final GetDetailsHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    final CognitoUserDetails userDetails = CognitoUser.this.getUserDetailsInternal(session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(userDetails);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getDetails(GetDetailsHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            CognitoUserDetails userDetails = this.getUserDetailsInternal(this.getCachedSession());
            callback.onSuccess(userDetails);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private CognitoUserDetails getUserDetailsInternal(CognitoUserSession session) {
        if (session != null && session.isValid()) {
            GetUserRequest getUserRequest = new GetUserRequest();
            getUserRequest.setAccessToken(session.getAccessToken().getJWTToken());
            GetUserResult userResult = this.cognitoIdentityProviderClient.getUser(getUserRequest);
            return new CognitoUserDetails(new CognitoUserAttributes(userResult.getUserAttributes()), new CognitoUserSettings(userResult.getMFAOptions()));
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void getAttributeVerificationCodeInBackground(String attributeName, VerificationHandler callback) {
        this.getAttributeVerificationCodeInBackground(Collections.emptyMap(), attributeName, callback);
    }

    public void getAttributeVerificationCodeInBackground(final Map<String, String> clientMetadata, final String attributeName, final VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    final GetUserAttributeVerificationCodeResult getUserAttributeVerificationCodeResult = CognitoUser.this.getAttributeVerificationCodeInternal(clientMetadata, attributeName, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(new CognitoUserCodeDeliveryDetails(getUserAttributeVerificationCodeResult.getCodeDeliveryDetails()));
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void getAttributeVerificationCode(String attributeName, VerificationHandler callback) {
        this.getAttributeVerificationCode(Collections.emptyMap(), attributeName, callback);
    }

    public void getAttributeVerificationCode(Map<String, String> clientMetadata, String attributeName, VerificationHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            GetUserAttributeVerificationCodeResult getUserAttributeVerificationCodeResult = this.getAttributeVerificationCodeInternal(clientMetadata, attributeName, this.getCachedSession());
            callback.onSuccess(new CognitoUserCodeDeliveryDetails(getUserAttributeVerificationCodeResult.getCodeDeliveryDetails()));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private GetUserAttributeVerificationCodeResult getAttributeVerificationCodeInternal(Map<String, String> clientMetadata, String attributeName, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            GetUserAttributeVerificationCodeRequest getUserAttributeVerificationCodeRequest = new GetUserAttributeVerificationCodeRequest();
            getUserAttributeVerificationCodeRequest.setAccessToken(session.getAccessToken().getJWTToken());
            getUserAttributeVerificationCodeRequest.setAttributeName(attributeName);
            getUserAttributeVerificationCodeRequest.setClientMetadata(clientMetadata);
            return this.cognitoIdentityProviderClient.getUserAttributeVerificationCode(getUserAttributeVerificationCodeRequest);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void verifyAttributeInBackground(final String attributeName, final String verificationCode, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.verifyAttributeInternal(attributeName, verificationCode, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void verifyAttribute(String attributeName, String verificationCode, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            VerifyUserAttributeResult verifyUserAttributeResult = this.verifyAttributeInternal(attributeName, verificationCode, this.getCachedSession());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private VerifyUserAttributeResult verifyAttributeInternal(String attributeName, String verificationCode, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            VerifyUserAttributeRequest verifyUserAttributeRequest = new VerifyUserAttributeRequest();
            verifyUserAttributeRequest.setAttributeName(attributeName);
            verifyUserAttributeRequest.setAccessToken(session.getAccessToken().getJWTToken());
            verifyUserAttributeRequest.setCode(verificationCode);
            return this.cognitoIdentityProviderClient.verifyUserAttribute(verifyUserAttributeRequest);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void associateSoftwareTokenInBackground(final String sessionToken, final RegisterMfaHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    boolean useSessionToken;
                    AssociateSoftwareTokenResult result;
                    CognitoUserSession cognitoTokens = user.getCachedSession();
                    if (!StringUtils.isBlank((CharSequence)sessionToken)) {
                        result = CognitoUser.this.associateTotpMfaInternalWithSession(sessionToken);
                        useSessionToken = true;
                    } else {
                        result = CognitoUser.this.associateTotpMfaInternalWithTokens(cognitoTokens);
                        useSessionToken = false;
                    }
                    final String nextSessionToken = result.getSession();
                    final HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("type", "SOFTWARE_TOKEN_MFA");
                    parameters.put("secretKey", result.getSecretCode());
                    returnCallback = useSessionToken ? new Runnable(){

                        @Override
                        public void run() {
                            callback.onVerify(new VerifyMfaContinuation(CognitoUser.this.context, CognitoUser.this.clientId, user, callback, parameters, true, nextSessionToken, true));
                        }
                    } : new Runnable(){

                        @Override
                        public void run() {
                            callback.onVerify(new VerifyMfaContinuation(CognitoUser.this.context, CognitoUser.this.clientId, user, callback, parameters, false, nextSessionToken, true));
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void associateSoftwareToken(String sessionToken, RegisterMfaHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        CognitoUser user = this;
        try {
            boolean useSessionToken;
            AssociateSoftwareTokenResult result;
            CognitoUserSession cognitoTokens = user.getCachedSession();
            if (!StringUtils.isBlank((CharSequence)sessionToken)) {
                result = this.associateTotpMfaInternalWithSession(sessionToken);
                useSessionToken = true;
            } else {
                result = this.associateTotpMfaInternalWithTokens(cognitoTokens);
                useSessionToken = false;
            }
            String nextSessionToken = result.getSession();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("type", "SOFTWARE_TOKEN_MFA");
            parameters.put("secretKey", result.getSecretCode());
            callback.onVerify(new VerifyMfaContinuation(this.context, this.clientId, user, callback, parameters, useSessionToken, nextSessionToken, false));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private AssociateSoftwareTokenResult associateTotpMfaInternalWithTokens(CognitoUserSession session) {
        if (session != null && session.isValid()) {
            AssociateSoftwareTokenRequest request = new AssociateSoftwareTokenRequest();
            request.setAccessToken(session.getAccessToken().getJWTToken());
            return this.associateTotpMfaInternal(request);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    private AssociateSoftwareTokenResult associateTotpMfaInternalWithSession(String sessionToken) {
        if (sessionToken != null) {
            AssociateSoftwareTokenRequest request = new AssociateSoftwareTokenRequest();
            request.setSession(sessionToken);
            return this.associateTotpMfaInternal(request);
        }
        throw new CognitoNotAuthorizedException("session token is invalid");
    }

    private AssociateSoftwareTokenResult associateTotpMfaInternal(AssociateSoftwareTokenRequest request) {
        return this.cognitoIdentityProviderClient.associateSoftwareToken(request);
    }

    public void verifySoftwareTokenInBackground(final String sessionToken, final String totpCode, final String friendlyName, final RegisterMfaHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    boolean useSessionToken;
                    VerifySoftwareTokenResult result;
                    CognitoUserSession cognitoTokens = user.getCachedSession();
                    if (!StringUtils.isBlank((CharSequence)sessionToken)) {
                        result = CognitoUser.this.verifyTotpAssociationWithSession(sessionToken, totpCode, friendlyName);
                        useSessionToken = true;
                    } else {
                        result = CognitoUser.this.verifyTotpAssociationWithTokens(cognitoTokens, totpCode, friendlyName);
                        useSessionToken = false;
                    }
                    final String newSessionToken = result.getSession();
                    if (VerifySoftwareTokenResponseType.ERROR.equals(result.getStatus())) {
                        throw new CognitoInternalErrorException("verification failed");
                    }
                    returnCallback = useSessionToken ? new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(newSessionToken);
                        }
                    } : new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(null);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void verifySoftwareToken(String sessionToken, String totpCode, String friendlyName, RegisterMfaHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        CognitoUser user = this;
        try {
            boolean useSessionToken;
            VerifySoftwareTokenResult result;
            CognitoUserSession cognitoTokens = user.getCachedSession();
            if (!StringUtils.isBlank((CharSequence)sessionToken)) {
                result = this.verifyTotpAssociationWithSession(sessionToken, totpCode, friendlyName);
                useSessionToken = true;
            } else {
                result = this.verifyTotpAssociationWithTokens(cognitoTokens, totpCode, friendlyName);
                useSessionToken = false;
            }
            String newSessionToken = result.getSession();
            if (VerifySoftwareTokenResponseType.ERROR.equals(result.getStatus())) {
                throw new CognitoInternalErrorException("verification failed");
            }
            if (useSessionToken) {
                callback.onSuccess(newSessionToken);
            } else {
                callback.onSuccess(null);
            }
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private VerifySoftwareTokenResult verifyTotpAssociationWithTokens(CognitoUserSession session, String totpCode, String friendlyName) {
        if (session != null && session.isValid()) {
            VerifySoftwareTokenRequest request = new VerifySoftwareTokenRequest();
            request.setAccessToken(session.getAccessToken().getJWTToken());
            request.setUserCode(totpCode);
            request.setFriendlyDeviceName(friendlyName);
            return this.verifyTotpAssociationInternal(request);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    private VerifySoftwareTokenResult verifyTotpAssociationWithSession(String session, String totpCode, String friendlyName) {
        if (session != null) {
            VerifySoftwareTokenRequest request = new VerifySoftwareTokenRequest();
            request.setSession(session);
            request.setUserCode(totpCode);
            request.setFriendlyDeviceName(friendlyName);
            return this.verifyTotpAssociationInternal(request);
        }
        throw new CognitoNotAuthorizedException("session token is invalid");
    }

    private VerifySoftwareTokenResult verifyTotpAssociationInternal(VerifySoftwareTokenRequest request) {
        return this.cognitoIdentityProviderClient.verifySoftwareToken(request);
    }

    public void updateAttributesInBackground(CognitoUserAttributes attributes, UpdateAttributesHandler callback) {
        this.updateAttributesInBackground(Collections.emptyMap(), attributes, callback);
    }

    public void updateAttributesInBackground(final Map<String, String> clientMetadata, final CognitoUserAttributes attributes, final UpdateAttributesHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    UpdateUserAttributesResult updateUserAttributesResult = CognitoUser.this.updateAttributesInternal(clientMetadata, attributes, session);
                    final ArrayList<CognitoUserCodeDeliveryDetails> attributesVerificationList = new ArrayList<CognitoUserCodeDeliveryDetails>();
                    if (updateUserAttributesResult.getCodeDeliveryDetailsList() != null) {
                        for (CodeDeliveryDetailsType details : updateUserAttributesResult.getCodeDeliveryDetailsList()) {
                            attributesVerificationList.add(new CognitoUserCodeDeliveryDetails(details));
                        }
                    }
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(attributesVerificationList);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void updateAttributes(CognitoUserAttributes attributes, UpdateAttributesHandler callback) {
        this.updateAttributes(attributes, Collections.emptyMap(), callback);
    }

    public void updateAttributes(CognitoUserAttributes attributes, Map<String, String> clientMetadata, UpdateAttributesHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            CognitoUserSession session = this.getCachedSession();
            UpdateUserAttributesResult updateUserAttributesResult = this.updateAttributesInternal(clientMetadata, attributes, session);
            ArrayList<CognitoUserCodeDeliveryDetails> attributesVerificationList = new ArrayList<CognitoUserCodeDeliveryDetails>();
            if (updateUserAttributesResult.getCodeDeliveryDetailsList() != null) {
                for (CodeDeliveryDetailsType details : updateUserAttributesResult.getCodeDeliveryDetailsList()) {
                    attributesVerificationList.add(new CognitoUserCodeDeliveryDetails(details));
                }
            }
            callback.onSuccess(attributesVerificationList);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private UpdateUserAttributesResult updateAttributesInternal(Map<String, String> clientMetadata, CognitoUserAttributes attributes, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            UpdateUserAttributesRequest updateUserAttributesRequest = new UpdateUserAttributesRequest();
            updateUserAttributesRequest.setAccessToken(session.getAccessToken().getJWTToken());
            updateUserAttributesRequest.setUserAttributes(attributes.getAttributesList());
            updateUserAttributesRequest.setClientMetadata(clientMetadata);
            return this.cognitoIdentityProviderClient.updateUserAttributes(updateUserAttributesRequest);
        }
        throw new CognitoNotAuthorizedException("user is not authenticated");
    }

    public void deleteAttributesInBackground(final List<String> attributeNamesToDelete, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.deleteAttributesInternal(attributeNamesToDelete, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void deleteAttributes(List<String> attributeNamesToDelete, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.deleteAttributesInternal(attributeNamesToDelete, this.getCachedSession());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void deleteAttributesInternal(List<String> attributeNamesToDelete, CognitoUserSession session) {
        if (session == null) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (!session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (attributeNamesToDelete == null) {
            return;
        }
        if (attributeNamesToDelete.size() < 1) {
            return;
        }
        DeleteUserAttributesRequest deleteUserAttributesRequest = new DeleteUserAttributesRequest();
        deleteUserAttributesRequest.setAccessToken(session.getAccessToken().getJWTToken());
        deleteUserAttributesRequest.setUserAttributeNames(attributeNamesToDelete);
        this.cognitoIdentityProviderClient.deleteUserAttributes(deleteUserAttributesRequest);
    }

    public RevokeTokenResult revokeTokens() {
        try {
            CognitoUserSession cognitoUserSession = this.getCachedSession();
            String accessToken = cognitoUserSession.getAccessToken().getJWTToken();
            if (CognitoJWTParser.hasClaim(accessToken, "origin_jti")) {
                String refreshToken = cognitoUserSession.getRefreshToken().getToken();
                RevokeTokenRequest request = new RevokeTokenRequest();
                request.setToken(refreshToken);
                request.setClientId(this.clientId);
                if (!StringUtils.isBlank((CharSequence)this.clientSecret)) {
                    request.setClientSecret(this.clientSecret);
                }
                return this.cognitoIdentityProviderClient.revokeToken(request);
            }
            LOGGER.debug((Object)"Access Token does not contain `origin_jti` claim. Skip revoking tokens.");
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to revoke tokens.", (Throwable)e);
        }
        return null;
    }

    public void signOut() {
        this.cipSession = null;
        this.clearCachedTokens();
    }

    public void globalSignOutInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.globalSignOutInternal(session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            CognitoUser.this.signOut();
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void globalSignOut(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.globalSignOutInternal(this.getCachedSession());
            this.signOut();
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void globalSignOutInternal(CognitoUserSession session) {
        if (session == null) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (!session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        GlobalSignOutRequest globalSignOutRequest = new GlobalSignOutRequest();
        globalSignOutRequest.setAccessToken(this.getCachedSession().getAccessToken().getJWTToken());
        this.cognitoIdentityProviderClient.globalSignOut(globalSignOutRequest);
    }

    public void deleteUserInBackground(final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUserSession session = user.getCachedSession();
                    CognitoUser.this.deleteUserInternal(session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void deleteUser(GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.deleteUserInternal(this.getCachedSession());
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void deleteUserInternal(CognitoUserSession session) {
        if (session == null) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        if (!session.isValid()) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        DeleteUserRequest deleteUserRequest = new DeleteUserRequest();
        deleteUserRequest.setAccessToken(session.getAccessToken().getJWTToken());
        this.cognitoIdentityProviderClient.deleteUser(deleteUserRequest);
    }

    public void setUserSettingsInBackground(final CognitoUserSettings cognitoUserSettings, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUserSession session = this.getCachedSession();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.setUserSettingsInternal(cognitoUserSettings, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void setUserSettings(CognitoUserSettings cognitoUserSettings, GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            this.setUserSettingsInternal(cognitoUserSettings, this.getCachedSession());
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    private void setUserSettingsInternal(CognitoUserSettings cognitoUserSettings, CognitoUserSession session) {
        if (session != null && session.isValid()) {
            if (cognitoUserSettings == null) {
                throw new CognitoParameterInvalidException("user attributes is null");
            }
        } else {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        SetUserSettingsRequest setUserSettingsRequest = new SetUserSettingsRequest();
        setUserSettingsRequest.setAccessToken(session.getAccessToken().getJWTToken());
        setUserSettingsRequest.setMFAOptions(cognitoUserSettings.getSettingsList());
        SetUserSettingsResult setUserSettingsResult = this.cognitoIdentityProviderClient.setUserSettings(setUserSettingsRequest);
    }

    public void setUserMfaSettingsInBackground(final List<CognitoMfaSettings> mfaSettings, final GenericHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUserSession session = this.getCachedSession();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    CognitoUser.this.setUserMfaSettingsInternal(mfaSettings, session);
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess();
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    private void setUserMfaSettingsInternal(List<CognitoMfaSettings> mfaSettings, CognitoUserSession session) {
        SetUserMFAPreferenceRequest request;
        if (session != null && session.isValid()) {
            if (mfaSettings == null || mfaSettings.size() < 1) {
                throw new CognitoParameterInvalidException("mfa settings are empty");
            }
            request = new SetUserMFAPreferenceRequest();
            request.setAccessToken(session.getAccessToken().getJWTToken());
            for (CognitoMfaSettings mfaSetting : mfaSettings) {
                if ("SMS_MFA".equals(mfaSetting.getMfaName())) {
                    SMSMfaSettingsType smsMfaSetting = new SMSMfaSettingsType();
                    smsMfaSetting.setEnabled(mfaSetting.isEnabled());
                    smsMfaSetting.setPreferredMfa(mfaSetting.isPreferred());
                    request.setSMSMfaSettings(smsMfaSetting);
                }
                if (!"TOTP_MFA".equals(mfaSetting.getMfaName())) continue;
                SoftwareTokenMfaSettingsType softwareTokenMfaSetting = new SoftwareTokenMfaSettingsType();
                softwareTokenMfaSetting.setEnabled(mfaSetting.isEnabled());
                softwareTokenMfaSetting.setPreferredMfa(mfaSetting.isPreferred());
                request.setSoftwareTokenMfaSettings(softwareTokenMfaSetting);
            }
        } else {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        SetUserMFAPreferenceResult setUserMFAPreferenceResult = this.cognitoIdentityProviderClient.setUserMFAPreference(request);
    }

    private void clearCachedTokens() {
        try {
            String csiIdTokenKey = String.format("CognitoIdentityProvider.%s.%s.idToken", this.clientId, this.userId);
            String csiAccessTokenKey = String.format("CognitoIdentityProvider.%s.%s.accessToken", this.clientId, this.userId);
            String csiRefreshTokenKey = String.format("CognitoIdentityProvider.%s.%s.refreshToken", this.clientId, this.userId);
            this.pool.awsKeyValueStore.remove(csiIdTokenKey);
            this.pool.awsKeyValueStore.remove(csiAccessTokenKey);
            this.pool.awsKeyValueStore.remove(csiRefreshTokenKey);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while deleting from SharedPreferences", (Throwable)e);
        }
    }

    private CognitoUserSession readCachedTokens() {
        CognitoUserSession userSession = new CognitoUserSession(null, null, null);
        try {
            String csiIdTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".idToken";
            String csiAccessTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".accessToken";
            String csiRefreshTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".refreshToken";
            CognitoIdToken csiCachedIdToken = null;
            CognitoAccessToken csiCachedAccessToken = null;
            CognitoRefreshToken csiCachedRefreshToken = null;
            if (this.pool.awsKeyValueStore.contains(csiIdTokenKey)) {
                String idToken = this.pool.awsKeyValueStore.get(csiIdTokenKey);
                if (idToken != null) {
                    csiCachedIdToken = new CognitoIdToken(idToken);
                } else {
                    LOGGER.warn((Object)("IdToken for " + csiIdTokenKey + " is null."));
                }
            }
            if (this.pool.awsKeyValueStore.contains(csiAccessTokenKey)) {
                String accessToken = this.pool.awsKeyValueStore.get(csiAccessTokenKey);
                if (accessToken != null) {
                    csiCachedAccessToken = new CognitoAccessToken(accessToken);
                } else {
                    LOGGER.warn((Object)("IdToken for " + csiAccessTokenKey + " is null."));
                }
            }
            if (this.pool.awsKeyValueStore.contains(csiRefreshTokenKey)) {
                String refreshToken = this.pool.awsKeyValueStore.get(csiRefreshTokenKey);
                if (refreshToken != null) {
                    csiCachedRefreshToken = new CognitoRefreshToken(refreshToken);
                } else {
                    LOGGER.warn((Object)("IdToken for " + csiRefreshTokenKey + " is null."));
                }
            }
            userSession = new CognitoUserSession(csiCachedIdToken, csiCachedAccessToken, csiCachedRefreshToken);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while reading the tokens from the persistent store.", (Throwable)e);
        }
        return userSession;
    }

    void cacheTokens(CognitoUserSession session) {
        try {
            String csiIdTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".idToken";
            String csiAccessTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".accessToken";
            String csiRefreshTokenKey = "CognitoIdentityProvider." + this.clientId + "." + this.userId + ".refreshToken";
            String csiLastUserKey = "CognitoIdentityProvider." + this.clientId + ".LastAuthUser";
            if (session != null) {
                this.pool.awsKeyValueStore.put(csiIdTokenKey, session.getIdToken() != null ? session.getIdToken().getJWTToken() : null);
                this.pool.awsKeyValueStore.put(csiAccessTokenKey, session.getAccessToken() != null ? session.getAccessToken().getJWTToken() : null);
                this.pool.awsKeyValueStore.put(csiRefreshTokenKey, session.getRefreshToken() != null ? session.getRefreshToken().getToken() : null);
            }
            this.pool.awsKeyValueStore.put(csiLastUserKey, this.userId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while writing to SharedPreferences.", (Throwable)e);
        }
    }

    private CognitoUserSession getCognitoUserSession(AuthenticationResultType authResult) {
        return this.getCognitoUserSession(authResult, null);
    }

    private CognitoUserSession getCognitoUserSession(AuthenticationResultType authResult, CognitoRefreshToken refreshTokenOverride) {
        CognitoRefreshToken refreshToken;
        String idtoken = authResult.getIdToken();
        CognitoIdToken idToken = new CognitoIdToken(idtoken);
        String acctoken = authResult.getAccessToken();
        CognitoAccessToken accessToken = new CognitoAccessToken(acctoken);
        if (refreshTokenOverride != null) {
            refreshToken = refreshTokenOverride;
        } else {
            String reftoken = authResult.getRefreshToken();
            refreshToken = new CognitoRefreshToken(reftoken);
        }
        return new CognitoUserSession(idToken, accessToken, refreshToken);
    }

    private CognitoUserSession refreshSession(CognitoUserSession currSession) {
        CognitoUserSession cognitoUserSession = null;
        InitiateAuthRequest initiateAuthRequest = this.initiateRefreshTokenAuthRequest(currSession);
        InitiateAuthResult refreshSessionResult = this.cognitoIdentityProviderClient.initiateAuth(initiateAuthRequest);
        if (refreshSessionResult.getAuthenticationResult() == null) {
            throw new CognitoNotAuthorizedException("user is not authenticated");
        }
        cognitoUserSession = this.getCognitoUserSession(refreshSessionResult.getAuthenticationResult(), currSession.getRefreshToken());
        return cognitoUserSession;
    }

    public Runnable respondToChallenge(RespondToAuthChallengeRequest challengeResponse, AuthenticationHandler callback, boolean runInBackground) {
        return this.respondToChallenge(Collections.emptyMap(), challengeResponse, callback, runInBackground);
    }

    public Runnable respondToChallenge(final Map<String, String> clientMetadata, RespondToAuthChallengeRequest challengeResponse, final AuthenticationHandler callback, final boolean runInBackground) {
        try {
            if (challengeResponse != null && challengeResponse.getChallengeResponses() != null) {
                challengeResponse.getChallengeResponses().put("DEVICE_KEY", this.deviceKey);
            }
            RespondToAuthChallengeResult challenge = this.cognitoIdentityProviderClient.respondToAuthChallenge(challengeResponse);
            return this.handleChallenge(clientMetadata, challenge, null, callback, runInBackground);
        }
        catch (ResourceNotFoundException rna) {
            final CognitoUser cognitoUser = this;
            if (rna.getMessage().contains("Device")) {
                CognitoDeviceHelper.clearCachedDevice(this.usernameInternal, this.pool.getUserPoolId(), this.context);
                return new Runnable(){

                    @Override
                    public void run() {
                        AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(cognitoUser, CognitoUser.this.context, runInBackground, callback);
                        authenticationContinuation.setClientMetaData(clientMetadata);
                        callback.getAuthenticationDetails(authenticationContinuation, cognitoUser.getUserId());
                    }
                };
            }
            return new Runnable(){

                @Override
                public void run() {
                    callback.onFailure((Exception)((Object)rna));
                }
            };
        }
        catch (Exception e) {
            return new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(e);
                }
            };
        }
    }

    private Runnable startWithUserSrpAuth(final Map<String, String> clientMetadata, final AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, final boolean runInBackground) {
        return new Runnable(){

            @Override
            public void run() {
                AuthenticationHelper authenticationHelper = new AuthenticationHelper(CognitoUser.this.pool.getUserPoolId());
                InitiateAuthRequest initiateAuthRequest = CognitoUser.this.initiateUserSrpAuthRequest(clientMetadata, authenticationDetails, authenticationHelper);
                try {
                    InitiateAuthResult initiateAuthResult = CognitoUser.this.cognitoIdentityProviderClient.initiateAuth(initiateAuthRequest);
                    CognitoUser.this.updateInternalUsername(initiateAuthResult.getChallengeParameters());
                    if ("PASSWORD_VERIFIER".equals(initiateAuthResult.getChallengeName())) {
                        if (authenticationDetails.getPassword() == null) {
                            throw new IllegalStateException("Failed to find password in authentication details to response to PASSWORD_VERIFIER challenge");
                        }
                        RespondToAuthChallengeRequest challengeRequest = CognitoUser.this.userSrpAuthRequest(clientMetadata, initiateAuthResult.getChallengeParameters(), authenticationDetails.getPassword(), initiateAuthResult.getChallengeName(), initiateAuthResult.getSession(), authenticationHelper);
                        CognitoUser.this.respondToChallenge(clientMetadata, challengeRequest, callback, runInBackground).run();
                    } else {
                        CognitoUser.this.handleChallenge((Map<String, String>)clientMetadata, initiateAuthResult, authenticationDetails, callback, runInBackground).run();
                    }
                }
                catch (ResourceNotFoundException rna) {
                    CognitoUser cognitoUser = CognitoUser.this;
                    if (rna.getMessage().contains("Device")) {
                        CognitoDeviceHelper.clearCachedDevice(CognitoUser.this.usernameInternal, CognitoUser.this.pool.getUserPoolId(), CognitoUser.this.context);
                        AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(cognitoUser, CognitoUser.this.context, runInBackground, callback);
                        authenticationContinuation.setClientMetaData(clientMetadata);
                        callback.getAuthenticationDetails(authenticationContinuation, cognitoUser.getUserId());
                    } else {
                        callback.onFailure((Exception)((Object)rna));
                    }
                }
                catch (Exception e) {
                    callback.onFailure(e);
                }
            }
        };
    }

    private Runnable startWithCustomAuth(final Map<String, String> clientMetadata, final AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, final boolean runInBackground) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AuthenticationHelper authenticationHelper = new AuthenticationHelper(CognitoUser.this.getUserPoolId());
                    InitiateAuthRequest initiateAuthRequest = CognitoUser.this.initiateCustomAuthRequest(clientMetadata, authenticationDetails, authenticationHelper);
                    InitiateAuthResult initiateAuthResult = CognitoUser.this.cognitoIdentityProviderClient.initiateAuth(initiateAuthRequest);
                    CognitoUser.this.updateInternalUsername(initiateAuthResult.getChallengeParameters());
                    if ("PASSWORD_VERIFIER".equals(initiateAuthResult.getChallengeName())) {
                        if (authenticationDetails.getPassword() == null) {
                            throw new IllegalStateException("Failed to find password in authentication details to response to PASSWORD_VERIFIER challenge");
                        }
                        RespondToAuthChallengeRequest challengeRequest = CognitoUser.this.userSrpAuthRequest(clientMetadata, initiateAuthResult.getChallengeParameters(), authenticationDetails.getPassword(), initiateAuthResult.getChallengeName(), initiateAuthResult.getSession(), authenticationHelper);
                        CognitoUser.this.respondToChallenge(clientMetadata, challengeRequest, callback, runInBackground).run();
                    } else {
                        CognitoUser.this.handleChallenge((Map<String, String>)clientMetadata, initiateAuthResult, authenticationDetails, callback, runInBackground).run();
                    }
                }
                catch (Exception e) {
                    callback.onFailure(e);
                }
            }
        };
    }

    private Runnable handleChallenge(Map<String, String> clientMetadata, RespondToAuthChallengeResult challenge, AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, boolean runInBackground) {
        CognitoUser cognitoUser = this;
        Runnable nextTask = new Runnable(){

            @Override
            public void run() {
                callback.onFailure((Exception)((Object)new CognitoInternalErrorException("Authentication failed due to an internal error")));
            }
        };
        if (challenge == null) {
            return nextTask;
        }
        this.updateInternalUsername(challenge.getChallengeParameters());
        String challengeName = challenge.getChallengeName();
        if (challengeName == null) {
            final CognitoUserSession cognitoUserSession = this.getCognitoUserSession(challenge.getAuthenticationResult());
            this.cacheTokens(cognitoUserSession);
            NewDeviceMetadataType newDeviceMetadata = challenge.getAuthenticationResult().getNewDeviceMetadata();
            if (newDeviceMetadata == null) {
                nextTask = new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess(cognitoUserSession, null);
                    }
                };
            } else {
                ConfirmDeviceResult confirmDeviceResult = this.confirmDevice(newDeviceMetadata);
                if (confirmDeviceResult != null && confirmDeviceResult.isUserConfirmationNecessary().booleanValue()) {
                    final CognitoDevice newDevice = new CognitoDevice(newDeviceMetadata.getDeviceKey(), null, null, null, null, cognitoUser, this.context);
                    nextTask = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(cognitoUserSession, newDevice);
                        }
                    };
                } else {
                    nextTask = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(cognitoUserSession, null);
                        }
                    };
                }
            }
        } else {
            if ("PASSWORD_VERIFIER".equals(challengeName)) {
                return new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure((Exception)((Object)new CognitoInternalErrorException("Authentication failed due to an internal error: PASSWORD_VERIFIER challenge encountered not at the start of authentication flow")));
                    }
                };
            }
            if ("SMS_MFA".equals(challengeName) || "SOFTWARE_TOKEN_MFA".equals(challengeName)) {
                final MultiFactorAuthenticationContinuation multiFactorAuthenticationContinuation = new MultiFactorAuthenticationContinuation(cognitoUser, this.context, challenge, runInBackground, callback);
                multiFactorAuthenticationContinuation.setClientMetaData(clientMetadata);
                nextTask = new Runnable(){

                    @Override
                    public void run() {
                        callback.getMFACode(multiFactorAuthenticationContinuation);
                    }
                };
            } else if ("SELECT_MFA_TYPE".equals(challengeName)) {
                final ChooseMfaContinuation continuation = new ChooseMfaContinuation(cognitoUser, this.context, this.usernameInternal, this.clientId, this.secretHash, challenge, runInBackground, callback);
                nextTask = new Runnable(){

                    @Override
                    public void run() {
                        callback.authenticationChallenge(continuation);
                    }
                };
            } else if ("MFA_SETUP".equals(challengeName)) {
                final RegisterMfaContinuation continuation = new RegisterMfaContinuation(cognitoUser, this.context, this.usernameInternal, this.clientId, this.secretHash, challenge, runInBackground, callback);
                nextTask = new Runnable(){

                    @Override
                    public void run() {
                        callback.authenticationChallenge(continuation);
                    }
                };
            } else if ("DEVICE_SRP_AUTH".equals(challengeName)) {
                nextTask = this.deviceSrpAuthentication(clientMetadata, challenge, callback, runInBackground);
            } else if ("NEW_PASSWORD_REQUIRED".equals(challengeName)) {
                final NewPasswordContinuation newPasswordContinuation = new NewPasswordContinuation(cognitoUser, this.context, this.usernameInternal, this.clientId, CognitoSecretHash.getSecretHash(this.usernameInternal, this.clientId, this.clientSecret), challenge, runInBackground, callback);
                nextTask = new Runnable(){

                    @Override
                    public void run() {
                        callback.authenticationChallenge(newPasswordContinuation);
                    }
                };
            } else {
                final ChallengeContinuation challengeContinuation = new ChallengeContinuation(cognitoUser, this.context, this.usernameInternal, this.clientId, CognitoSecretHash.getSecretHash(this.usernameInternal, this.clientId, this.clientSecret), challenge, runInBackground, callback);
                challengeContinuation.setClientMetaData(clientMetadata);
                nextTask = new Runnable(){

                    @Override
                    public void run() {
                        callback.authenticationChallenge(challengeContinuation);
                    }
                };
            }
        }
        return nextTask;
    }

    private Runnable handleChallenge(Map<String, String> clientMetadata, InitiateAuthResult authResult, AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, boolean runInBackground) {
        try {
            RespondToAuthChallengeResult challenge = new RespondToAuthChallengeResult();
            challenge.setChallengeName(authResult.getChallengeName());
            challenge.setSession(authResult.getSession());
            challenge.setAuthenticationResult(authResult.getAuthenticationResult());
            challenge.setChallengeParameters(authResult.getChallengeParameters());
            return this.handleChallenge(clientMetadata, challenge, authenticationDetails, callback, runInBackground);
        }
        catch (Exception e) {
            return new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(e);
                }
            };
        }
    }

    private Runnable startWithUserPasswordAuth(final Map<String, String> clientMetadata, final AuthenticationDetails authenticationDetails, final AuthenticationHandler callback, final boolean runInBackground) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    InitiateAuthRequest initiateAuthRequest = CognitoUser.this.initiateUserPasswordAuthRequest(clientMetadata, authenticationDetails);
                    InitiateAuthResult initiateAuthResult = CognitoUser.this.cognitoIdentityProviderClient.initiateAuth(initiateAuthRequest);
                    CognitoUser.this.usernameInternal = initiateAuthResult.getChallengeParameters().get("USER_ID_FOR_SRP");
                    CognitoUser.this.handleChallenge((Map<String, String>)clientMetadata, initiateAuthResult, authenticationDetails, callback, runInBackground).run();
                }
                catch (Exception e) {
                    callback.onFailure(e);
                }
            }
        };
    }

    private InitiateAuthRequest initiateUserPasswordAuthRequest(Map<String, String> clientMetadata, AuthenticationDetails authenticationDetails) {
        if (StringUtils.isBlank((CharSequence)authenticationDetails.getUserId()) || StringUtils.isBlank((CharSequence)authenticationDetails.getPassword())) {
            throw new CognitoNotAuthorizedException("User name and password are required");
        }
        InitiateAuthRequest authRequest = new InitiateAuthRequest();
        authRequest.setAuthFlow("USER_PASSWORD_AUTH");
        authRequest.setClientId(this.clientId);
        authRequest.setClientMetadata(clientMetadata);
        authRequest.addAuthParametersEntry("USERNAME", authenticationDetails.getUserId());
        authRequest.addAuthParametersEntry("PASSWORD", authenticationDetails.getPassword());
        authRequest.addAuthParametersEntry("SECRET_HASH", CognitoSecretHash.getSecretHash(this.userId, this.clientId, this.clientSecret));
        if (authenticationDetails.getValidationData() != null && authenticationDetails.getValidationData().size() > 0) {
            HashMap<String, String> userValidationData = new HashMap<String, String>();
            for (AttributeType attribute : authenticationDetails.getValidationData()) {
                userValidationData.put(attribute.getName(), attribute.getValue());
            }
            authRequest.setClientMetadata(userValidationData);
        }
        return authRequest;
    }

    private Runnable deviceSrpAuthentication(final Map<String, String> clientMetadata, RespondToAuthChallengeResult challenge, final AuthenticationHandler callback, final boolean runInBackground) {
        String deviceSecret = CognitoDeviceHelper.getDeviceSecret(this.usernameInternal, this.pool.getUserPoolId(), this.context);
        String deviceGroupKey = CognitoDeviceHelper.getDeviceGroupKey(this.usernameInternal, this.pool.getUserPoolId(), this.context);
        AuthenticationHelper authenticationHelper = new AuthenticationHelper(deviceGroupKey);
        RespondToAuthChallengeRequest devicesAuthRequest = this.initiateDevicesAuthRequest(clientMetadata, challenge, authenticationHelper);
        try {
            RespondToAuthChallengeResult initiateDeviceAuthResult = this.cognitoIdentityProviderClient.respondToAuthChallenge(devicesAuthRequest);
            if ("DEVICE_PASSWORD_VERIFIER".equals(initiateDeviceAuthResult.getChallengeName())) {
                RespondToAuthChallengeRequest challengeResponse = this.deviceSrpAuthRequest(clientMetadata, initiateDeviceAuthResult, deviceSecret, deviceGroupKey, authenticationHelper);
                RespondToAuthChallengeResult deviceSRPAuthResult = this.cognitoIdentityProviderClient.respondToAuthChallenge(challengeResponse);
                return this.handleChallenge(clientMetadata, deviceSRPAuthResult, null, callback, runInBackground);
            }
            return this.handleChallenge(clientMetadata, initiateDeviceAuthResult, null, callback, runInBackground);
        }
        catch (NotAuthorizedException na) {
            final CognitoUser cognitoUser = this;
            CognitoDeviceHelper.clearCachedDevice(this.usernameInternal, this.pool.getUserPoolId(), this.context);
            return new Runnable(){

                @Override
                public void run() {
                    AuthenticationContinuation authenticationContinuation = new AuthenticationContinuation(cognitoUser, CognitoUser.this.context, runInBackground, callback);
                    authenticationContinuation.setClientMetaData(clientMetadata);
                    callback.getAuthenticationDetails(authenticationContinuation, cognitoUser.getUserId());
                }
            };
        }
        catch (Exception e) {
            return new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(e);
                }
            };
        }
    }

    private InitiateAuthRequest initiateUserSrpAuthRequest(Map<String, String> clientMetadata, AuthenticationDetails authenticationDetails, AuthenticationHelper authenticationHelper) {
        String pinpointEndpointId;
        this.userId = authenticationDetails.getUserId();
        InitiateAuthRequest initiateAuthRequest = new InitiateAuthRequest();
        initiateAuthRequest.setAuthFlow("USER_SRP_AUTH");
        initiateAuthRequest.setClientId(this.clientId);
        initiateAuthRequest.setClientMetadata(clientMetadata);
        initiateAuthRequest.addAuthParametersEntry("SECRET_HASH", CognitoSecretHash.getSecretHash(this.userId, this.clientId, this.clientSecret));
        initiateAuthRequest.addAuthParametersEntry("USERNAME", authenticationDetails.getUserId());
        initiateAuthRequest.addAuthParametersEntry("SRP_A", authenticationHelper.getA().toString(16));
        if (this.deviceKey == null) {
            initiateAuthRequest.addAuthParametersEntry("DEVICE_KEY", CognitoDeviceHelper.getDeviceKey(authenticationDetails.getUserId(), this.pool.getUserPoolId(), this.context));
        } else {
            initiateAuthRequest.addAuthParametersEntry("DEVICE_KEY", this.deviceKey);
        }
        if (authenticationDetails.getValidationData() != null && authenticationDetails.getValidationData().size() > 0) {
            HashMap<String, String> userValidationData = new HashMap<String, String>();
            for (AttributeType attribute : authenticationDetails.getValidationData()) {
                userValidationData.put(attribute.getName(), attribute.getValue());
            }
            initiateAuthRequest.setClientMetadata(userValidationData);
        }
        if ((pinpointEndpointId = this.pool.getPinpointEndpointId()) != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            initiateAuthRequest.setAnalyticsMetadata(amd);
        }
        initiateAuthRequest.setUserContextData(this.getUserContextData());
        return initiateAuthRequest;
    }

    private InitiateAuthRequest initiateCustomAuthRequest(Map<String, String> clientMetadata, AuthenticationDetails authenticationDetails, AuthenticationHelper authenticationHelper) {
        InitiateAuthRequest authRequest = new InitiateAuthRequest();
        authRequest.setAuthFlow("CUSTOM_AUTH");
        authRequest.setClientId(this.clientId);
        authRequest.setClientMetadata(clientMetadata);
        Map<String, String> authenticationParameters = authenticationDetails.getAuthenticationParameters();
        if (this.clientSecret != null && authenticationParameters.get("SECRET_HASH") == null) {
            this.secretHash = CognitoSecretHash.getSecretHash(authenticationDetails.getUserId(), this.clientId, this.clientSecret);
            authenticationParameters.put("SECRET_HASH", this.secretHash);
        }
        if ("SRP_A".equals(authenticationDetails.getCustomChallenge())) {
            authenticationParameters.put("SRP_A", authenticationHelper.getA().toString(16));
        }
        authRequest.setAuthParameters(authenticationDetails.getAuthenticationParameters());
        if (authenticationDetails.getValidationData() != null && authenticationDetails.getValidationData().size() > 0) {
            HashMap<String, String> userValidationData = new HashMap<String, String>();
            for (AttributeType attribute : authenticationDetails.getValidationData()) {
                userValidationData.put(attribute.getName(), attribute.getValue());
            }
            authRequest.setClientMetadata(userValidationData);
        }
        authRequest.setUserContextData(this.getUserContextData());
        return authRequest;
    }

    private RespondToAuthChallengeRequest initiateDevicesAuthRequest(Map<String, String> clientMetadata, RespondToAuthChallengeResult challenge, AuthenticationHelper authenticationHelper) {
        RespondToAuthChallengeRequest initiateDevicesAuthRequest = new RespondToAuthChallengeRequest();
        initiateDevicesAuthRequest.setClientId(this.clientId);
        initiateDevicesAuthRequest.setChallengeName("DEVICE_SRP_AUTH");
        initiateDevicesAuthRequest.setClientMetadata(clientMetadata);
        initiateDevicesAuthRequest.setSession(challenge.getSession());
        initiateDevicesAuthRequest.addChallengeResponsesEntry("USERNAME", this.usernameInternal);
        initiateDevicesAuthRequest.addChallengeResponsesEntry("SRP_A", authenticationHelper.getA().toString(16));
        initiateDevicesAuthRequest.addChallengeResponsesEntry("DEVICE_KEY", this.deviceKey);
        initiateDevicesAuthRequest.addChallengeResponsesEntry("SECRET_HASH", this.secretHash);
        initiateDevicesAuthRequest.setUserContextData(this.getUserContextData());
        return initiateDevicesAuthRequest;
    }

    private InitiateAuthRequest initiateRefreshTokenAuthRequest(CognitoUserSession currSession) {
        InitiateAuthRequest initiateAuthRequest = new InitiateAuthRequest();
        initiateAuthRequest.addAuthParametersEntry("REFRESH_TOKEN", currSession.getRefreshToken().getToken());
        if (this.deviceKey == null) {
            this.deviceKey = this.usernameInternal != null ? CognitoDeviceHelper.getDeviceKey(this.usernameInternal, this.pool.getUserPoolId(), this.context) : CognitoDeviceHelper.getDeviceKey(currSession.getUsername(), this.pool.getUserPoolId(), this.context);
        }
        initiateAuthRequest.addAuthParametersEntry("DEVICE_KEY", this.deviceKey);
        initiateAuthRequest.addAuthParametersEntry("SECRET_HASH", this.clientSecret);
        initiateAuthRequest.setClientId(this.clientId);
        initiateAuthRequest.setAuthFlow("REFRESH_TOKEN_AUTH");
        String pinpointEndpointId = this.pool.getPinpointEndpointId();
        if (pinpointEndpointId != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            initiateAuthRequest.setAnalyticsMetadata(amd);
        }
        initiateAuthRequest.setUserContextData(this.getUserContextData());
        return initiateAuthRequest;
    }

    private RespondToAuthChallengeRequest userSrpAuthRequest(Map<String, String> clientMetadata, Map<String, String> challengeParameters, String password, String challengeName, String session, AuthenticationHelper authenticationHelper) {
        byte[] hmac;
        String dateString;
        String userId = challengeParameters.get("USERNAME");
        String userIdForSRP = challengeParameters.get("USER_ID_FOR_SRP");
        String srpBString = challengeParameters.get("SRP_B");
        String saltString = challengeParameters.get("SALT");
        String secretBlockString = challengeParameters.get("SECRET_BLOCK");
        this.usernameInternal = userId;
        this.deviceKey = CognitoDeviceHelper.getDeviceKey(this.usernameInternal, this.pool.getUserPoolId(), this.context);
        this.secretHash = CognitoSecretHash.getSecretHash(this.usernameInternal, this.clientId, this.clientSecret);
        BigInteger srpB = new BigInteger(srpBString, 16);
        if (srpB.mod(AuthenticationHelper.N).equals(BigInteger.ZERO)) {
            throw new CognitoInternalErrorException("SRP error, B cannot be zero");
        }
        BigInteger salt = new BigInteger(saltString, 16);
        byte[] key = authenticationHelper.getPasswordAuthenticationKey(userIdForSRP, password, srpB, salt);
        Date timestamp = new Date();
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA256");
            mac.init(keySpec);
            mac.update(this.pool.getUserPoolId().split("_", 2)[1].getBytes(StringUtils.UTF8));
            mac.update(userIdForSRP.getBytes(StringUtils.UTF8));
            byte[] secretBlock = Base64.decode((String)secretBlockString);
            mac.update(secretBlock);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateString = simpleDateFormat.format(timestamp);
            byte[] dateBytes = dateString.getBytes(StringUtils.UTF8);
            hmac = mac.doFinal(dateBytes);
        }
        catch (Exception e) {
            throw new CognitoInternalErrorException("SRP error", e);
        }
        HashMap<String, String> srpAuthResponses = new HashMap<String, String>();
        srpAuthResponses.put("PASSWORD_CLAIM_SECRET_BLOCK", secretBlockString);
        srpAuthResponses.put("PASSWORD_CLAIM_SIGNATURE", new String(Base64.encode((byte[])hmac), StringUtils.UTF8));
        srpAuthResponses.put("TIMESTAMP", dateString);
        srpAuthResponses.put("USERNAME", this.usernameInternal);
        srpAuthResponses.put("DEVICE_KEY", this.deviceKey);
        srpAuthResponses.put("SECRET_HASH", this.secretHash);
        RespondToAuthChallengeRequest authChallengeRequest = new RespondToAuthChallengeRequest();
        authChallengeRequest.setChallengeName(challengeName);
        authChallengeRequest.setClientId(this.clientId);
        authChallengeRequest.setSession(session);
        authChallengeRequest.setChallengeResponses(srpAuthResponses);
        authChallengeRequest.setClientMetadata(clientMetadata);
        String pinpointEndpointId = this.pool.getPinpointEndpointId();
        if (pinpointEndpointId != null) {
            AnalyticsMetadataType amd = new AnalyticsMetadataType();
            amd.setAnalyticsEndpointId(pinpointEndpointId);
            authChallengeRequest.setAnalyticsMetadata(amd);
        }
        authChallengeRequest.setUserContextData(this.getUserContextData());
        return authChallengeRequest;
    }

    public RespondToAuthChallengeRequest deviceSrpAuthRequest(Map<String, String> clientMetadata, RespondToAuthChallengeResult challenge, String deviceSecret, String deviceGroupKey, AuthenticationHelper authenticationHelper) {
        byte[] hmac;
        String dateString;
        this.usernameInternal = challenge.getChallengeParameters().get("USERNAME");
        BigInteger srpB = new BigInteger(challenge.getChallengeParameters().get("SRP_B"), 16);
        if (srpB.mod(AuthenticationHelper.N).equals(BigInteger.ZERO)) {
            throw new CognitoInternalErrorException("SRP error, B cannot be zero");
        }
        BigInteger salt = new BigInteger(challenge.getChallengeParameters().get("SALT"), 16);
        byte[] key = authenticationHelper.getPasswordAuthenticationKey(this.deviceKey, deviceSecret, srpB, salt);
        Date timestamp = new Date();
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA256");
            mac.init(keySpec);
            mac.update(deviceGroupKey.getBytes(StringUtils.UTF8));
            mac.update(this.deviceKey.getBytes(StringUtils.UTF8));
            byte[] secretBlock = Base64.decode((String)challenge.getChallengeParameters().get("SECRET_BLOCK"));
            mac.update(secretBlock);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateString = simpleDateFormat.format(timestamp);
            byte[] dateBytes = dateString.getBytes(StringUtils.UTF8);
            hmac = mac.doFinal(dateBytes);
        }
        catch (Exception e) {
            throw new CognitoInternalErrorException("SRP error", e);
        }
        this.secretHash = CognitoSecretHash.getSecretHash(this.usernameInternal, this.clientId, this.clientSecret);
        HashMap<String, String> srpAuthResponses = new HashMap<String, String>();
        srpAuthResponses.put("PASSWORD_CLAIM_SECRET_BLOCK", challenge.getChallengeParameters().get("SECRET_BLOCK"));
        srpAuthResponses.put("PASSWORD_CLAIM_SIGNATURE", new String(Base64.encode((byte[])hmac), StringUtils.UTF8));
        srpAuthResponses.put("TIMESTAMP", dateString);
        srpAuthResponses.put("USERNAME", this.usernameInternal);
        srpAuthResponses.put("DEVICE_KEY", this.deviceKey);
        srpAuthResponses.put("SECRET_HASH", this.secretHash);
        RespondToAuthChallengeRequest authChallengeRequest = new RespondToAuthChallengeRequest();
        authChallengeRequest.setChallengeName(challenge.getChallengeName());
        authChallengeRequest.setClientId(this.clientId);
        authChallengeRequest.setSession(challenge.getSession());
        authChallengeRequest.setChallengeResponses(srpAuthResponses);
        authChallengeRequest.setUserContextData(this.getUserContextData());
        authChallengeRequest.setClientMetadata(clientMetadata);
        return authChallengeRequest;
    }

    public void listDevicesInBackground(final int limit, final String paginationToken, final DevicesHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        final CognitoUser user = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable returnCallback;
                Handler handler = new Handler(CognitoUser.this.context.getMainLooper());
                try {
                    ListDevicesResult listDevicesResult = CognitoUser.this.listDevicesInternal(user.getCachedSession(), limit, paginationToken);
                    final ArrayList<CognitoDevice> devicesList = new ArrayList<CognitoDevice>();
                    for (DeviceType device : listDevicesResult.getDevices()) {
                        devicesList.add(new CognitoDevice(device, user, CognitoUser.this.context));
                    }
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(devicesList);
                        }
                    };
                }
                catch (Exception e) {
                    returnCallback = new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    };
                }
                handler.post(returnCallback);
            }
        }).start();
    }

    public void listDevices(int limit, String paginationToken, DevicesHandler callback) {
        if (callback == null) {
            throw new CognitoParameterInvalidException("callback is null");
        }
        try {
            ListDevicesResult listDevicesResult = this.listDevicesInternal(this.getCachedSession(), limit, paginationToken);
            ArrayList<CognitoDevice> devicesList = new ArrayList<CognitoDevice>();
            for (DeviceType device : listDevicesResult.getDevices()) {
                devicesList.add(new CognitoDevice(device, this, this.context));
            }
            callback.onSuccess(devicesList);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public CognitoDevice thisDevice() {
        if (this.deviceKey == null) {
            if (this.usernameInternal != null) {
                this.deviceKey = CognitoDeviceHelper.getDeviceKey(this.usernameInternal, this.pool.getUserPoolId(), this.context);
            } else if (this.userId != null) {
                this.deviceKey = CognitoDeviceHelper.getDeviceKey(this.userId, this.pool.getUserPoolId(), this.context);
                if (this.deviceKey == null) {
                    CognitoUserSession currSession = this.readCachedTokens();
                    this.deviceKey = CognitoDeviceHelper.getDeviceKey(currSession.getUsername(), this.pool.getUserPoolId(), this.context);
                }
            }
        }
        if (this.deviceKey != null) {
            return new CognitoDevice(this.deviceKey, null, null, null, null, this, this.context);
        }
        return null;
    }

    private ConfirmDeviceResult confirmDevice(NewDeviceMetadataType deviceMetadata) {
        Map<String, String> deviceSrpVerifiers = CognitoDeviceHelper.generateVerificationParameters(deviceMetadata.getDeviceKey(), deviceMetadata.getDeviceGroupKey());
        ConfirmDeviceResult confirmDeviceResult = new ConfirmDeviceResult();
        confirmDeviceResult.setUserConfirmationNecessary(false);
        try {
            confirmDeviceResult = this.confirmDeviceInternal(this.getCachedSession(), deviceMetadata.getDeviceKey(), deviceSrpVerifiers.get("verifier"), deviceSrpVerifiers.get("salt"), CognitoDeviceHelper.getDeviceName());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Device confirmation failed: ", (Throwable)e);
            return null;
        }
        CognitoDeviceHelper.cacheDeviceKey(this.usernameInternal, this.pool.getUserPoolId(), deviceMetadata.getDeviceKey(), this.context);
        CognitoDeviceHelper.cacheDeviceVerifier(this.usernameInternal, this.pool.getUserPoolId(), deviceSrpVerifiers.get("secret"), this.context);
        CognitoDeviceHelper.cacheDeviceGroupKey(this.usernameInternal, this.pool.getUserPoolId(), deviceMetadata.getDeviceGroupKey(), this.context);
        return confirmDeviceResult;
    }

    private ListDevicesResult listDevicesInternal(CognitoUserSession session, int limit, String paginationToken) {
        if (session != null && session.isValid()) {
            ListDevicesRequest listDevicesRequest = new ListDevicesRequest();
            if (limit < 1) {
                listDevicesRequest.setLimit(10);
            } else {
                listDevicesRequest.setLimit(limit);
            }
            listDevicesRequest.setPaginationToken(paginationToken);
            listDevicesRequest.setAccessToken(session.getAccessToken().getJWTToken());
            return this.cognitoIdentityProviderClient.listDevices(listDevicesRequest);
        }
        throw new CognitoNotAuthorizedException("User is not authorized");
    }

    private ConfirmDeviceResult confirmDeviceInternal(CognitoUserSession session, String deviceKey, String passwordVerifier, String salt, String deviceName) {
        if (session != null && session.isValid()) {
            if (deviceKey != null && deviceName != null) {
                DeviceSecretVerifierConfigType deviceConfig = new DeviceSecretVerifierConfigType();
                deviceConfig.setPasswordVerifier(passwordVerifier);
                deviceConfig.setSalt(salt);
                ConfirmDeviceRequest confirmDeviceRequest = new ConfirmDeviceRequest();
                confirmDeviceRequest.setAccessToken(session.getAccessToken().getJWTToken());
                confirmDeviceRequest.setDeviceKey(deviceKey);
                confirmDeviceRequest.setDeviceName(deviceName);
                confirmDeviceRequest.setDeviceSecretVerifierConfig(deviceConfig);
                return this.cognitoIdentityProviderClient.confirmDevice(confirmDeviceRequest);
            }
            if (deviceKey == null) {
                throw new CognitoParameterInvalidException("Device key is null");
            }
            throw new CognitoParameterInvalidException("Device name is null");
        }
        throw new CognitoNotAuthorizedException("User is not authorized");
    }

    private void updateInternalUsername(Map<String, String> challengeParameters) {
        if (this.usernameInternal == null && challengeParameters != null && challengeParameters.containsKey("USERNAME")) {
            this.usernameInternal = challengeParameters.get("USERNAME");
            this.deviceKey = CognitoDeviceHelper.getDeviceKey(this.usernameInternal, this.pool.getUserPoolId(), this.context);
            if (this.secretHash == null) {
                this.secretHash = CognitoSecretHash.getSecretHash(this.usernameInternal, this.clientId, this.clientSecret);
            }
        }
    }

    private UserContextDataType getUserContextData() {
        return this.pool.getUserContextData(this.userId);
    }

    private static class AuthenticationHelper {
        private BigInteger a;
        private BigInteger A;
        private String poolName;
        private static final String HEX_N = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF";
        private static final BigInteger N = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
        private static final BigInteger GG = BigInteger.valueOf(2L);
        private static final BigInteger KK;
        private static final int EPHEMERAL_KEY_LENGTH = 1024;
        private static final int DERIVED_KEY_SIZE = 16;
        private static final String DERIVED_KEY_INFO = "Caldera Derived Key";
        private static final ThreadLocal<MessageDigest> THREAD_MESSAGE_DIGEST;
        private static final SecureRandom SECURE_RANDOM;

        public AuthenticationHelper(String userPoolName) {
            do {
                this.a = new BigInteger(1024, SECURE_RANDOM).mod(N);
                this.A = GG.modPow(this.a, N);
            } while (this.A.mod(N).equals(BigInteger.ZERO));
            this.poolName = userPoolName.contains("_") ? userPoolName.split("_", 2)[1] : userPoolName;
        }

        public BigInteger geta() {
            return this.a;
        }

        public BigInteger getA() {
            return this.A;
        }

        public byte[] getPasswordAuthenticationKey(String userId, String userPassword, BigInteger B, BigInteger salt) {
            MessageDigest messageDigest = THREAD_MESSAGE_DIGEST.get();
            messageDigest.reset();
            messageDigest.update(this.A.toByteArray());
            BigInteger u = new BigInteger(1, messageDigest.digest(B.toByteArray()));
            if (u.equals(BigInteger.ZERO)) {
                throw new CognitoInternalErrorException("Hash of A and B cannot be zero");
            }
            messageDigest.reset();
            messageDigest.update(this.poolName.getBytes(StringUtils.UTF8));
            messageDigest.update(userId.getBytes(StringUtils.UTF8));
            messageDigest.update(":".getBytes(StringUtils.UTF8));
            byte[] userIdHash = messageDigest.digest(userPassword.getBytes(StringUtils.UTF8));
            messageDigest.reset();
            messageDigest.update(salt.toByteArray());
            BigInteger x = new BigInteger(1, messageDigest.digest(userIdHash));
            BigInteger s = B.subtract(KK.multiply(GG.modPow(x, N))).modPow(this.a.add(u.multiply(x)), N).mod(N);
            Hkdf hkdf = null;
            try {
                hkdf = Hkdf.getInstance("HmacSHA256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new CognitoInternalErrorException(e.getMessage(), e);
            }
            hkdf.init(s.toByteArray(), u.toByteArray());
            byte[] key = hkdf.deriveKey(DERIVED_KEY_INFO, 16);
            return key;
        }

        static {
            THREAD_MESSAGE_DIGEST = new ThreadLocal<MessageDigest>(){

                @Override
                protected MessageDigest initialValue() {
                    try {
                        return MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new CognitoInternalErrorException("Exception in authentication", e);
                    }
                }
            };
            try {
                SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
                MessageDigest messageDigest = THREAD_MESSAGE_DIGEST.get();
                messageDigest.reset();
                messageDigest.update(N.toByteArray());
                byte[] digest = messageDigest.digest(GG.toByteArray());
                KK = new BigInteger(1, digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CognitoInternalErrorException(e.getMessage(), e);
            }
        }
    }
}

