/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.MFAOptionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetUserSettingsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String accessToken;
    private List<MFAOptionType> mFAOptions;

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public SetUserSettingsRequest withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public List<MFAOptionType> getMFAOptions() {
        return this.mFAOptions;
    }

    public void setMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
            return;
        }
        this.mFAOptions = new ArrayList<MFAOptionType>(mFAOptions);
    }

    public SetUserSettingsRequest withMFAOptions(MFAOptionType ... mFAOptions) {
        if (this.getMFAOptions() == null) {
            this.mFAOptions = new ArrayList<MFAOptionType>(mFAOptions.length);
        }
        for (MFAOptionType value : mFAOptions) {
            this.mFAOptions.add(value);
        }
        return this;
    }

    public SetUserSettingsRequest withMFAOptions(Collection<MFAOptionType> mFAOptions) {
        this.setMFAOptions(mFAOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessToken() != null) {
            sb.append("AccessToken: " + this.getAccessToken() + ",");
        }
        if (this.getMFAOptions() != null) {
            sb.append("MFAOptions: " + this.getMFAOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessToken() == null ? 0 : this.getAccessToken().hashCode());
        hashCode = 31 * hashCode + (this.getMFAOptions() == null ? 0 : this.getMFAOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserSettingsRequest)) {
            return false;
        }
        SetUserSettingsRequest other = (SetUserSettingsRequest)obj;
        if (other.getAccessToken() == null ^ this.getAccessToken() == null) {
            return false;
        }
        if (other.getAccessToken() != null && !other.getAccessToken().equals(this.getAccessToken())) {
            return false;
        }
        if (other.getMFAOptions() == null ^ this.getMFAOptions() == null) {
            return false;
        }
        return other.getMFAOptions() == null || other.getMFAOptions().equals(this.getMFAOptions());
    }
}

