/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider;

import android.util.Log;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoAccessToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoIdToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.tokens.CognitoRefreshToken;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoIdentityProviderClientConfig;
import java.util.Date;

public class CognitoUserSession {
    private static final int SECS_CONVERSION = 1000;
    private static final String TAG = CognitoUserSession.class.getSimpleName();
    private final CognitoIdToken idToken;
    private final CognitoAccessToken accessToken;
    private final CognitoRefreshToken refreshToken;

    public CognitoUserSession(CognitoIdToken idToken, CognitoAccessToken accessToken, CognitoRefreshToken refreshToken) {
        this.idToken = idToken;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public CognitoIdToken getIdToken() {
        return this.idToken;
    }

    public CognitoAccessToken getAccessToken() {
        return this.accessToken;
    }

    public CognitoRefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isValid() {
        Date currentTimeStamp = new Date();
        try {
            if (this.idToken == null) {
                Log.w((String)TAG, (String)"CognitoUserSession is not valid because idToken is null.");
                return false;
            }
            if (this.accessToken == null) {
                Log.w((String)TAG, (String)"CognitoUserSession is not valid because accessToken is null.");
                return false;
            }
            return currentTimeStamp.before(this.idToken.getExpiration()) & currentTimeStamp.before(this.accessToken.getExpiration());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidForThreshold() {
        try {
            if (this.idToken == null) {
                Log.w((String)TAG, (String)"CognitoUserSession is not valid because idToken is null.");
                return false;
            }
            if (this.accessToken == null) {
                Log.w((String)TAG, (String)"CognitoUserSession is not valid because accessToken is null.");
                return false;
            }
            long currentTime = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
            long idTokenExpiresInMilliSeconds = this.idToken.getExpiration().getTime() - currentTime;
            long accessTokenExpiresInMilliSeconds = this.accessToken.getExpiration().getTime() - currentTime;
            return idTokenExpiresInMilliSeconds > CognitoIdentityProviderClientConfig.getRefreshThreshold() && accessTokenExpiresInMilliSeconds > CognitoIdentityProviderClientConfig.getRefreshThreshold();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getUsername() {
        if (this.accessToken != null) {
            try {
                return this.accessToken.getUsername();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

