/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.UserType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AttributeTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class UserTypeJsonMarshaller {
    private static UserTypeJsonMarshaller instance;

    UserTypeJsonMarshaller() {
    }

    public void marshall(UserType userType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (userType.getUsername() != null) {
            String username = userType.getUsername();
            jsonWriter.name("Username");
            jsonWriter.value(username);
        }
        if (userType.getAttributes() != null) {
            List<AttributeType> attributes = userType.getAttributes();
            jsonWriter.name("Attributes");
            jsonWriter.beginArray();
            for (AttributeType attributesItem : attributes) {
                if (attributesItem == null) continue;
                AttributeTypeJsonMarshaller.getInstance().marshall(attributesItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (userType.getUserCreateDate() != null) {
            Date userCreateDate = userType.getUserCreateDate();
            jsonWriter.name("UserCreateDate");
            jsonWriter.value(userCreateDate);
        }
        if (userType.getUserLastModifiedDate() != null) {
            Date userLastModifiedDate = userType.getUserLastModifiedDate();
            jsonWriter.name("UserLastModifiedDate");
            jsonWriter.value(userLastModifiedDate);
        }
        if (userType.getEnabled() != null) {
            Boolean enabled = userType.getEnabled();
            jsonWriter.name("Enabled");
            jsonWriter.value(enabled.booleanValue());
        }
        if (userType.getUserStatus() != null) {
            String userStatus = userType.getUserStatus();
            jsonWriter.name("UserStatus");
            jsonWriter.value(userStatus);
        }
        jsonWriter.endObject();
    }

    public static UserTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UserTypeJsonMarshaller();
        }
        return instance;
    }
}

