/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.KeyType;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class KeyTypeJsonUnmarshaller
implements Unmarshaller<KeyType, JsonUnmarshallerContext> {
    private static KeyTypeJsonUnmarshaller instance;

    KeyTypeJsonUnmarshaller() {
    }

    public KeyType unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyType keyType = new KeyType();
        AwsJsonReader reader = context.getReader();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("kty")) {
                keyType.setKty(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("alg")) {
                keyType.setAlg(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("use")) {
                keyType.setUse(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("kid")) {
                keyType.setKid(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("n")) {
                keyType.setN(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("e")) {
                keyType.setE(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return keyType;
    }

    public static KeyTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyTypeJsonUnmarshaller();
        }
        return instance;
    }
}

