/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.CreateUserPoolRequest;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.PasswordPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateUserPoolRequestMarshaller
implements Marshaller<Request<CreateUserPoolRequest>, CreateUserPoolRequest> {
    public Request<CreateUserPoolRequest> marshall(CreateUserPoolRequest createUserPoolRequest) {
        if (createUserPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserPoolRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.CreateUserPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag aliasAttributesList;
            ListWithAutoConstructFlag autoVerifiedAttributesList;
            LambdaConfigType lambdaConfig;
            UserPoolPolicyType policies;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createUserPoolRequest.getPoolName() != null) {
                jsonWriter.name("PoolName").value(createUserPoolRequest.getPoolName());
            }
            if ((policies = createUserPoolRequest.getPolicies()) != null) {
                jsonWriter.name("Policies");
                jsonWriter.beginObject();
                PasswordPolicyType passwordPolicy = policies.getPasswordPolicy();
                if (passwordPolicy != null) {
                    jsonWriter.name("PasswordPolicy");
                    jsonWriter.beginObject();
                    if (passwordPolicy.getMinimumLength() != null) {
                        jsonWriter.name("MinimumLength").value((Number)passwordPolicy.getMinimumLength());
                    }
                    if (passwordPolicy.isRequireUppercase() != null) {
                        jsonWriter.name("RequireUppercase").value(passwordPolicy.isRequireUppercase().booleanValue());
                    }
                    if (passwordPolicy.isRequireLowercase() != null) {
                        jsonWriter.name("RequireLowercase").value(passwordPolicy.isRequireLowercase().booleanValue());
                    }
                    if (passwordPolicy.isRequireNumbers() != null) {
                        jsonWriter.name("RequireNumbers").value(passwordPolicy.isRequireNumbers().booleanValue());
                    }
                    if (passwordPolicy.isRequireSymbols() != null) {
                        jsonWriter.name("RequireSymbols").value(passwordPolicy.isRequireSymbols().booleanValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((lambdaConfig = createUserPoolRequest.getLambdaConfig()) != null) {
                jsonWriter.name("LambdaConfig");
                jsonWriter.beginObject();
                if (lambdaConfig.getPreSignUp() != null) {
                    jsonWriter.name("PreSignUp").value(lambdaConfig.getPreSignUp());
                }
                if (lambdaConfig.getCustomMessage() != null) {
                    jsonWriter.name("CustomMessage").value(lambdaConfig.getCustomMessage());
                }
                if (lambdaConfig.getPostConfirmation() != null) {
                    jsonWriter.name("PostConfirmation").value(lambdaConfig.getPostConfirmation());
                }
                if (lambdaConfig.getPreAuthentication() != null) {
                    jsonWriter.name("PreAuthentication").value(lambdaConfig.getPreAuthentication());
                }
                if (lambdaConfig.getPostAuthentication() != null) {
                    jsonWriter.name("PostAuthentication").value(lambdaConfig.getPostAuthentication());
                }
                jsonWriter.endObject();
            }
            if (!((autoVerifiedAttributesList = (ListWithAutoConstructFlag)createUserPoolRequest.getAutoVerifiedAttributes()) == null || autoVerifiedAttributesList.isAutoConstruct() && autoVerifiedAttributesList.isEmpty())) {
                jsonWriter.name("AutoVerifiedAttributes");
                jsonWriter.beginArray();
                for (Object autoVerifiedAttributesListValue : autoVerifiedAttributesList) {
                    if (autoVerifiedAttributesListValue == null) continue;
                    jsonWriter.value((String)autoVerifiedAttributesListValue);
                }
                jsonWriter.endArray();
            }
            if (!((aliasAttributesList = (ListWithAutoConstructFlag)createUserPoolRequest.getAliasAttributes()) == null || aliasAttributesList.isAutoConstruct() && aliasAttributesList.isEmpty())) {
                jsonWriter.name("AliasAttributes");
                jsonWriter.beginArray();
                for (String aliasAttributesListValue : aliasAttributesList) {
                    if (aliasAttributesListValue == null) continue;
                    jsonWriter.value(aliasAttributesListValue);
                }
                jsonWriter.endArray();
            }
            if (createUserPoolRequest.getSmsVerificationMessage() != null) {
                jsonWriter.name("SmsVerificationMessage").value(createUserPoolRequest.getSmsVerificationMessage());
            }
            if (createUserPoolRequest.getEmailVerificationMessage() != null) {
                jsonWriter.name("EmailVerificationMessage").value(createUserPoolRequest.getEmailVerificationMessage());
            }
            if (createUserPoolRequest.getEmailVerificationSubject() != null) {
                jsonWriter.name("EmailVerificationSubject").value(createUserPoolRequest.getEmailVerificationSubject());
            }
            if (createUserPoolRequest.getSmsAuthenticationMessage() != null) {
                jsonWriter.name("SmsAuthenticationMessage").value(createUserPoolRequest.getSmsAuthenticationMessage());
            }
            if (createUserPoolRequest.getMfaConfiguration() != null) {
                jsonWriter.name("MfaConfiguration").value(createUserPoolRequest.getMfaConfiguration());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

