/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentityprovider.model.AuthenticateRequest;
import com.amazonaws.services.cognitoidentityprovider.model.PasswordClaimType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AuthenticateRequestMarshaller
implements Marshaller<Request<AuthenticateRequest>, AuthenticateRequest> {
    public Request<AuthenticateRequest> marshall(AuthenticateRequest authenticateRequest) {
        if (authenticateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authenticateRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.Authenticate";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            PasswordClaimType passwordClaim;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (authenticateRequest.getClientId() != null) {
                jsonWriter.name("ClientId").value(authenticateRequest.getClientId());
            }
            if (authenticateRequest.getSecretHash() != null) {
                jsonWriter.name("SecretHash").value(authenticateRequest.getSecretHash());
            }
            if (authenticateRequest.getUsername() != null) {
                jsonWriter.name("Username").value(authenticateRequest.getUsername());
            }
            if ((passwordClaim = authenticateRequest.getPasswordClaim()) != null) {
                jsonWriter.name("PasswordClaim");
                jsonWriter.beginObject();
                if (passwordClaim.getSecretBlock() != null) {
                    jsonWriter.name("SecretBlock").value(passwordClaim.getSecretBlock());
                }
                if (passwordClaim.getSignature() != null) {
                    jsonWriter.name("Signature").value(passwordClaim.getSignature());
                }
                jsonWriter.endObject();
            }
            if (authenticateRequest.getTimestamp() != null) {
                jsonWriter.name("Timestamp").value(authenticateRequest.getTimestamp());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

