/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AliasAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.StatusType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolMfaType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.VerifiedAttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UserPoolType
implements Serializable {
    private String id;
    private String name;
    private UserPoolPolicyType policies;
    private LambdaConfigType lambdaConfig;
    private String status;
    private Date lastModifiedDate;
    private Date creationDate;
    private ListWithAutoConstructFlag<SchemaAttributeType> schemaAttributes;
    private ListWithAutoConstructFlag<String> autoVerifiedAttributes;
    private ListWithAutoConstructFlag<String> aliasAttributes;
    private String smsVerificationMessage;
    private String emailVerificationMessage;
    private String emailVerificationSubject;
    private String smsAuthenticationMessage;
    private String mfaConfiguration;
    private Integer estimatedNumberOfUsers;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserPoolType withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserPoolType withName(String name) {
        this.name = name;
        return this;
    }

    public UserPoolPolicyType getPolicies() {
        return this.policies;
    }

    public void setPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
    }

    public UserPoolType withPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
        return this;
    }

    public LambdaConfigType getLambdaConfig() {
        return this.lambdaConfig;
    }

    public void setLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
    }

    public UserPoolType withLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UserPoolType withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(StatusType status) {
        this.status = status.toString();
    }

    public UserPoolType withStatus(StatusType status) {
        this.status = status.toString();
        return this;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public UserPoolType withLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        return this;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public UserPoolType withCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public List<SchemaAttributeType> getSchemaAttributes() {
        if (this.schemaAttributes == null) {
            this.schemaAttributes = new ListWithAutoConstructFlag();
            this.schemaAttributes.setAutoConstruct(true);
        }
        return this.schemaAttributes;
    }

    public void setSchemaAttributes(Collection<SchemaAttributeType> schemaAttributes) {
        if (schemaAttributes == null) {
            this.schemaAttributes = null;
            return;
        }
        ListWithAutoConstructFlag schemaAttributesCopy = new ListWithAutoConstructFlag(schemaAttributes.size());
        schemaAttributesCopy.addAll(schemaAttributes);
        this.schemaAttributes = schemaAttributesCopy;
    }

    public UserPoolType withSchemaAttributes(SchemaAttributeType ... schemaAttributes) {
        if (this.getSchemaAttributes() == null) {
            this.setSchemaAttributes(new ArrayList<SchemaAttributeType>(schemaAttributes.length));
        }
        for (SchemaAttributeType value : schemaAttributes) {
            this.getSchemaAttributes().add(value);
        }
        return this;
    }

    public UserPoolType withSchemaAttributes(Collection<SchemaAttributeType> schemaAttributes) {
        if (schemaAttributes == null) {
            this.schemaAttributes = null;
        } else {
            ListWithAutoConstructFlag schemaAttributesCopy = new ListWithAutoConstructFlag(schemaAttributes.size());
            schemaAttributesCopy.addAll(schemaAttributes);
            this.schemaAttributes = schemaAttributesCopy;
        }
        return this;
    }

    public List<String> getAutoVerifiedAttributes() {
        if (this.autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = new ListWithAutoConstructFlag();
            this.autoVerifiedAttributes.setAutoConstruct(true);
        }
        return this.autoVerifiedAttributes;
    }

    public void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
            return;
        }
        ListWithAutoConstructFlag autoVerifiedAttributesCopy = new ListWithAutoConstructFlag(autoVerifiedAttributes.size());
        autoVerifiedAttributesCopy.addAll(autoVerifiedAttributes);
        this.autoVerifiedAttributes = autoVerifiedAttributesCopy;
    }

    public UserPoolType withAutoVerifiedAttributes(String ... autoVerifiedAttributes) {
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(new ArrayList<String>(autoVerifiedAttributes.length));
        }
        for (String value : autoVerifiedAttributes) {
            this.getAutoVerifiedAttributes().add(value);
        }
        return this;
    }

    public UserPoolType withAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
        } else {
            ListWithAutoConstructFlag autoVerifiedAttributesCopy = new ListWithAutoConstructFlag(autoVerifiedAttributes.size());
            autoVerifiedAttributesCopy.addAll(autoVerifiedAttributes);
            this.autoVerifiedAttributes = autoVerifiedAttributesCopy;
        }
        return this;
    }

    public UserPoolType withAutoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
        ArrayList<String> autoVerifiedAttributesCopy = new ArrayList<String>(autoVerifiedAttributes.length);
        for (VerifiedAttributeType member : autoVerifiedAttributes) {
            autoVerifiedAttributesCopy.add(member.toString());
        }
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(autoVerifiedAttributesCopy);
        } else {
            this.getAutoVerifiedAttributes().addAll(autoVerifiedAttributesCopy);
        }
        return this;
    }

    public List<String> getAliasAttributes() {
        if (this.aliasAttributes == null) {
            this.aliasAttributes = new ListWithAutoConstructFlag();
            this.aliasAttributes.setAutoConstruct(true);
        }
        return this.aliasAttributes;
    }

    public void setAliasAttributes(Collection<String> aliasAttributes) {
        if (aliasAttributes == null) {
            this.aliasAttributes = null;
            return;
        }
        ListWithAutoConstructFlag aliasAttributesCopy = new ListWithAutoConstructFlag(aliasAttributes.size());
        aliasAttributesCopy.addAll(aliasAttributes);
        this.aliasAttributes = aliasAttributesCopy;
    }

    public UserPoolType withAliasAttributes(String ... aliasAttributes) {
        if (this.getAliasAttributes() == null) {
            this.setAliasAttributes(new ArrayList<String>(aliasAttributes.length));
        }
        for (String value : aliasAttributes) {
            this.getAliasAttributes().add(value);
        }
        return this;
    }

    public UserPoolType withAliasAttributes(Collection<String> aliasAttributes) {
        if (aliasAttributes == null) {
            this.aliasAttributes = null;
        } else {
            ListWithAutoConstructFlag aliasAttributesCopy = new ListWithAutoConstructFlag(aliasAttributes.size());
            aliasAttributesCopy.addAll(aliasAttributes);
            this.aliasAttributes = aliasAttributesCopy;
        }
        return this;
    }

    public UserPoolType withAliasAttributes(AliasAttributeType ... aliasAttributes) {
        ArrayList<String> aliasAttributesCopy = new ArrayList<String>(aliasAttributes.length);
        for (AliasAttributeType member : aliasAttributes) {
            aliasAttributesCopy.add(member.toString());
        }
        if (this.getAliasAttributes() == null) {
            this.setAliasAttributes(aliasAttributesCopy);
        } else {
            this.getAliasAttributes().addAll(aliasAttributesCopy);
        }
        return this;
    }

    public String getSmsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public void setSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
    }

    public UserPoolType withSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
        return this;
    }

    public String getEmailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public void setEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
    }

    public UserPoolType withEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
        return this;
    }

    public String getEmailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public void setEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
    }

    public UserPoolType withEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
        return this;
    }

    public String getSmsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
    }

    public UserPoolType withSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
        return this;
    }

    public String getMfaConfiguration() {
        return this.mfaConfiguration;
    }

    public void setMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
    }

    public UserPoolType withMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
        return this;
    }

    public void setMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
    }

    public UserPoolType withMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
        return this;
    }

    public Integer getEstimatedNumberOfUsers() {
        return this.estimatedNumberOfUsers;
    }

    public void setEstimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
        this.estimatedNumberOfUsers = estimatedNumberOfUsers;
    }

    public UserPoolType withEstimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
        this.estimatedNumberOfUsers = estimatedNumberOfUsers;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: " + this.getPolicies() + ",");
        }
        if (this.getLambdaConfig() != null) {
            sb.append("LambdaConfig: " + this.getLambdaConfig() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: " + this.getLastModifiedDate() + ",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: " + this.getCreationDate() + ",");
        }
        if (this.getSchemaAttributes() != null) {
            sb.append("SchemaAttributes: " + this.getSchemaAttributes() + ",");
        }
        if (this.getAutoVerifiedAttributes() != null) {
            sb.append("AutoVerifiedAttributes: " + this.getAutoVerifiedAttributes() + ",");
        }
        if (this.getAliasAttributes() != null) {
            sb.append("AliasAttributes: " + this.getAliasAttributes() + ",");
        }
        if (this.getSmsVerificationMessage() != null) {
            sb.append("SmsVerificationMessage: " + this.getSmsVerificationMessage() + ",");
        }
        if (this.getEmailVerificationMessage() != null) {
            sb.append("EmailVerificationMessage: " + this.getEmailVerificationMessage() + ",");
        }
        if (this.getEmailVerificationSubject() != null) {
            sb.append("EmailVerificationSubject: " + this.getEmailVerificationSubject() + ",");
        }
        if (this.getSmsAuthenticationMessage() != null) {
            sb.append("SmsAuthenticationMessage: " + this.getSmsAuthenticationMessage() + ",");
        }
        if (this.getMfaConfiguration() != null) {
            sb.append("MfaConfiguration: " + this.getMfaConfiguration() + ",");
        }
        if (this.getEstimatedNumberOfUsers() != null) {
            sb.append("EstimatedNumberOfUsers: " + this.getEstimatedNumberOfUsers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaConfig() == null ? 0 : this.getLambdaConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaAttributes() == null ? 0 : this.getSchemaAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAutoVerifiedAttributes() == null ? 0 : this.getAutoVerifiedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAliasAttributes() == null ? 0 : this.getAliasAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSmsVerificationMessage() == null ? 0 : this.getSmsVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationMessage() == null ? 0 : this.getEmailVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationSubject() == null ? 0 : this.getEmailVerificationSubject().hashCode());
        hashCode = 31 * hashCode + (this.getSmsAuthenticationMessage() == null ? 0 : this.getSmsAuthenticationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMfaConfiguration() == null ? 0 : this.getMfaConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedNumberOfUsers() == null ? 0 : this.getEstimatedNumberOfUsers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolType)) {
            return false;
        }
        UserPoolType other = (UserPoolType)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getLambdaConfig() == null ^ this.getLambdaConfig() == null) {
            return false;
        }
        if (other.getLambdaConfig() != null && !other.getLambdaConfig().equals(this.getLambdaConfig())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getSchemaAttributes() == null ^ this.getSchemaAttributes() == null) {
            return false;
        }
        if (other.getSchemaAttributes() != null && !other.getSchemaAttributes().equals(this.getSchemaAttributes())) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() == null ^ this.getAutoVerifiedAttributes() == null) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() != null && !other.getAutoVerifiedAttributes().equals(this.getAutoVerifiedAttributes())) {
            return false;
        }
        if (other.getAliasAttributes() == null ^ this.getAliasAttributes() == null) {
            return false;
        }
        if (other.getAliasAttributes() != null && !other.getAliasAttributes().equals(this.getAliasAttributes())) {
            return false;
        }
        if (other.getSmsVerificationMessage() == null ^ this.getSmsVerificationMessage() == null) {
            return false;
        }
        if (other.getSmsVerificationMessage() != null && !other.getSmsVerificationMessage().equals(this.getSmsVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationMessage() == null ^ this.getEmailVerificationMessage() == null) {
            return false;
        }
        if (other.getEmailVerificationMessage() != null && !other.getEmailVerificationMessage().equals(this.getEmailVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationSubject() == null ^ this.getEmailVerificationSubject() == null) {
            return false;
        }
        if (other.getEmailVerificationSubject() != null && !other.getEmailVerificationSubject().equals(this.getEmailVerificationSubject())) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() == null ^ this.getSmsAuthenticationMessage() == null) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() != null && !other.getSmsAuthenticationMessage().equals(this.getSmsAuthenticationMessage())) {
            return false;
        }
        if (other.getMfaConfiguration() == null ^ this.getMfaConfiguration() == null) {
            return false;
        }
        if (other.getMfaConfiguration() != null && !other.getMfaConfiguration().equals(this.getMfaConfiguration())) {
            return false;
        }
        if (other.getEstimatedNumberOfUsers() == null ^ this.getEstimatedNumberOfUsers() == null) {
            return false;
        }
        return other.getEstimatedNumberOfUsers() == null || other.getEstimatedNumberOfUsers().equals(this.getEstimatedNumberOfUsers());
    }
}

