/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

/**
 * Alias Attribute Type
 */
public enum AliasAttributeType {
    
    Phone_number("phone_number"),
    Email("email"),
    Preferred_username("preferred_username");

    private String value;

    private AliasAttributeType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *            real value
     * @return AliasAttributeType corresponding to the value
     */
    public static AliasAttributeType fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        
        } else if ("phone_number".equals(value)) {
            return AliasAttributeType.Phone_number;
        } else if ("email".equals(value)) {
            return AliasAttributeType.Email;
        } else if ("preferred_username".equals(value)) {
            return AliasAttributeType.Preferred_username;
        } else {
            throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
        }
    }
}
    