/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.LambdaConfigType;
import com.amazonaws.services.cognitoidentityprovider.model.PasswordPolicyType;
import com.amazonaws.services.cognitoidentityprovider.model.UpdateUserPoolRequest;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolPolicyType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateUserPoolRequestMarshaller
implements Marshaller<Request<UpdateUserPoolRequest>, UpdateUserPoolRequest> {
    public Request<UpdateUserPoolRequest> marshall(UpdateUserPoolRequest updateUserPoolRequest) {
        if (updateUserPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateUserPoolRequest, "AmazonCognitoIdentityProvider");
        String target = "AWSCognitoIdentityProviderService.UpdateUserPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag autoVerifiedAttributesList;
            LambdaConfigType lambdaConfig;
            UserPoolPolicyType policies;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateUserPoolRequest.getUserPoolId() != null) {
                jsonWriter.name("UserPoolId").value(updateUserPoolRequest.getUserPoolId());
            }
            if ((policies = updateUserPoolRequest.getPolicies()) != null) {
                jsonWriter.name("Policies");
                jsonWriter.beginObject();
                PasswordPolicyType passwordPolicy = policies.getPasswordPolicy();
                if (passwordPolicy != null) {
                    jsonWriter.name("PasswordPolicy");
                    jsonWriter.beginObject();
                    if (passwordPolicy.getMinimumLength() != null) {
                        jsonWriter.name("MinimumLength").value((Number)passwordPolicy.getMinimumLength());
                    }
                    if (passwordPolicy.isRequireUppercase() != null) {
                        jsonWriter.name("RequireUppercase").value(passwordPolicy.isRequireUppercase().booleanValue());
                    }
                    if (passwordPolicy.isRequireLowercase() != null) {
                        jsonWriter.name("RequireLowercase").value(passwordPolicy.isRequireLowercase().booleanValue());
                    }
                    if (passwordPolicy.isRequireNumbers() != null) {
                        jsonWriter.name("RequireNumbers").value(passwordPolicy.isRequireNumbers().booleanValue());
                    }
                    if (passwordPolicy.isRequireSymbols() != null) {
                        jsonWriter.name("RequireSymbols").value(passwordPolicy.isRequireSymbols().booleanValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((lambdaConfig = updateUserPoolRequest.getLambdaConfig()) != null) {
                jsonWriter.name("LambdaConfig");
                jsonWriter.beginObject();
                if (lambdaConfig.getPreSignUp() != null) {
                    jsonWriter.name("PreSignUp").value(lambdaConfig.getPreSignUp());
                }
                if (lambdaConfig.getCustomMessage() != null) {
                    jsonWriter.name("CustomMessage").value(lambdaConfig.getCustomMessage());
                }
                if (lambdaConfig.getPostConfirmation() != null) {
                    jsonWriter.name("PostConfirmation").value(lambdaConfig.getPostConfirmation());
                }
                if (lambdaConfig.getPreAuthentication() != null) {
                    jsonWriter.name("PreAuthentication").value(lambdaConfig.getPreAuthentication());
                }
                if (lambdaConfig.getPostAuthentication() != null) {
                    jsonWriter.name("PostAuthentication").value(lambdaConfig.getPostAuthentication());
                }
                jsonWriter.endObject();
            }
            if (!((autoVerifiedAttributesList = (ListWithAutoConstructFlag)updateUserPoolRequest.getAutoVerifiedAttributes()) == null || autoVerifiedAttributesList.isAutoConstruct() && autoVerifiedAttributesList.isEmpty())) {
                jsonWriter.name("AutoVerifiedAttributes");
                jsonWriter.beginArray();
                for (String autoVerifiedAttributesListValue : autoVerifiedAttributesList) {
                    if (autoVerifiedAttributesListValue == null) continue;
                    jsonWriter.value(autoVerifiedAttributesListValue);
                }
                jsonWriter.endArray();
            }
            if (updateUserPoolRequest.getSmsVerificationMessage() != null) {
                jsonWriter.name("SmsVerificationMessage").value(updateUserPoolRequest.getSmsVerificationMessage());
            }
            if (updateUserPoolRequest.getEmailVerificationMessage() != null) {
                jsonWriter.name("EmailVerificationMessage").value(updateUserPoolRequest.getEmailVerificationMessage());
            }
            if (updateUserPoolRequest.getEmailVerificationSubject() != null) {
                jsonWriter.name("EmailVerificationSubject").value(updateUserPoolRequest.getEmailVerificationSubject());
            }
            if (updateUserPoolRequest.getSmsAuthenticationMessage() != null) {
                jsonWriter.name("SmsAuthenticationMessage").value(updateUserPoolRequest.getSmsAuthenticationMessage());
            }
            if (updateUserPoolRequest.getMfaConfiguration() != null) {
                jsonWriter.name("MfaConfiguration").value(updateUserPoolRequest.getMfaConfiguration());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

