/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;

public class AuthenticationContinuation
implements CognitoIdentityProviderContinuation<String> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final CognitoUser user;
    private final AuthenticationHandler callback;
    private final boolean runInBackground;
    private AuthenticationDetails authenticationDetails = null;

    public AuthenticationContinuation(CognitoUser user, boolean runInBackground, AuthenticationHandler callback) {
        this.user = user;
        this.callback = callback;
        this.runInBackground = runInBackground;
    }

    @Override
    public String getParameters() {
        return "AuthenticationDetails";
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            this.user.authenticateUserInBackground(this.authenticationDetails, this.callback);
        } else {
            this.user.authenticateUser(this.authenticationDetails, this.callback);
        }
    }

    public void setAuthenticationDetails(AuthenticationDetails authenticationDetails) {
        this.authenticationDetails = authenticationDetails;
    }
}

