/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.MFAOptionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetUserResult
implements Serializable {
    private String username;
    private ListWithAutoConstructFlag<AttributeType> userAttributes;
    private ListWithAutoConstructFlag<MFAOptionType> mFAOptions;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public GetUserResult withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        if (this.userAttributes == null) {
            this.userAttributes = new ListWithAutoConstructFlag();
            this.userAttributes.setAutoConstruct(true);
        }
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        ListWithAutoConstructFlag userAttributesCopy = new ListWithAutoConstructFlag(userAttributes.size());
        userAttributesCopy.addAll(userAttributes);
        this.userAttributes = userAttributesCopy;
    }

    public GetUserResult withUserAttributes(AttributeType ... userAttributes) {
        if (this.getUserAttributes() == null) {
            this.setUserAttributes(new ArrayList<AttributeType>(userAttributes.length));
        }
        for (AttributeType value : userAttributes) {
            this.getUserAttributes().add(value);
        }
        return this;
    }

    public GetUserResult withUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
        } else {
            ListWithAutoConstructFlag userAttributesCopy = new ListWithAutoConstructFlag(userAttributes.size());
            userAttributesCopy.addAll(userAttributes);
            this.userAttributes = userAttributesCopy;
        }
        return this;
    }

    public List<MFAOptionType> getMFAOptions() {
        if (this.mFAOptions == null) {
            this.mFAOptions = new ListWithAutoConstructFlag();
            this.mFAOptions.setAutoConstruct(true);
        }
        return this.mFAOptions;
    }

    public void setMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
            return;
        }
        ListWithAutoConstructFlag mFAOptionsCopy = new ListWithAutoConstructFlag(mFAOptions.size());
        mFAOptionsCopy.addAll(mFAOptions);
        this.mFAOptions = mFAOptionsCopy;
    }

    public GetUserResult withMFAOptions(MFAOptionType ... mFAOptions) {
        if (this.getMFAOptions() == null) {
            this.setMFAOptions(new ArrayList<MFAOptionType>(mFAOptions.length));
        }
        for (MFAOptionType value : mFAOptions) {
            this.getMFAOptions().add(value);
        }
        return this;
    }

    public GetUserResult withMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
        } else {
            ListWithAutoConstructFlag mFAOptionsCopy = new ListWithAutoConstructFlag(mFAOptions.size());
            mFAOptionsCopy.addAll(mFAOptions);
            this.mFAOptions = mFAOptionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: " + this.getUsername() + ",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: " + this.getUserAttributes() + ",");
        }
        if (this.getMFAOptions() != null) {
            sb.append("MFAOptions: " + this.getMFAOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMFAOptions() == null ? 0 : this.getMFAOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResult)) {
            return false;
        }
        GetUserResult other = (GetUserResult)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getMFAOptions() == null ^ this.getMFAOptions() == null) {
            return false;
        }
        return other.getMFAOptions() == null || other.getMFAOptions().equals(this.getMFAOptions());
    }
}

