/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.exceptions.CognitoParameterInvalidException;
import com.amazonaws.services.cognitoidentityprovider.model.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthenticationDetails {
    private String authenticationType;
    private final String userId;
    private String password;
    private List<AttributeType> validationData;
    private Map<String, String> authenticationParameters;

    public AuthenticationDetails(String userId, String password, Map<String, String> validationData) {
        this.authenticationType = "PASSWORD_VERIFIER";
        this.userId = userId;
        this.password = password;
        this.setValidationData(validationData);
    }

    public AuthenticationDetails(String userId, String password, Map<String, String> authenticationParameters, Map<String, String> validationData) {
        this.userId = userId;
        this.password = password;
        if (authenticationParameters != null) {
            this.authenticationType = "CUSTOM_CHALLENGE";
            this.authenticationParameters = authenticationParameters;
            this.setAuthenticationParameter("USERNAME", userId);
            this.setCustomChallenge("SRP_A");
            this.setValidationData(validationData);
        } else {
            this.authenticationType = null;
        }
    }

    public AuthenticationDetails(String userId, Map<String, String> authenticationParameters, Map<String, String> validationData) {
        this.userId = userId;
        if (authenticationParameters != null) {
            this.authenticationType = "CUSTOM_CHALLENGE";
            this.authenticationParameters = authenticationParameters;
            this.setAuthenticationParameter("USERNAME", userId);
            this.setValidationData(validationData);
        } else {
            this.authenticationType = null;
        }
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        if ("PASSWORD_VERIFIER".equals(this.authenticationType) || "USER_PASSWORD".equals(this.authenticationType)) {
            this.authenticationParameters = null;
        } else if ("CUSTOM_CHALLENGE".equals(this.authenticationType)) {
            this.password = null;
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<AttributeType> getValidationData() {
        return this.validationData;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public Map<String, String> getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public void setCustomChallenge(String customChallenge) {
        if ("PASSWORD_VERIFIER".equals(this.authenticationType) || "USER_PASSWORD".equals(this.authenticationType)) {
            throw new CognitoParameterInvalidException(String.format("Cannot set custom challenge when the authentication type is %s.", this.authenticationType));
        }
        this.authenticationType = "CUSTOM_CHALLENGE";
        this.setAuthenticationParameter("CHALLENGE_NAME", customChallenge);
    }

    public String getCustomChallenge() {
        return this.authenticationParameters.get("CHALLENGE_NAME");
    }

    private void setValidationData(Map<String, String> validationData) {
        if (validationData != null) {
            this.validationData = new ArrayList<AttributeType>();
            for (Map.Entry<String, String> data : validationData.entrySet()) {
                AttributeType validation = new AttributeType();
                validation.setName(data.getKey());
                validation.setValue(data.getValue());
                this.validationData.add(validation);
            }
        } else {
            this.validationData = null;
        }
    }

    public void setAuthenticationParameters(Map<String, String> authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
    }

    public void setAuthenticationParameter(String key, String value) {
        if (key != null) {
            if (this.authenticationParameters == null) {
                this.authenticationParameters = new HashMap<String, String>();
            }
        } else {
            throw new CognitoParameterInvalidException("A null key was used to add a new authentications parameter.");
        }
        this.authenticationParameters.put(key, value);
    }
}

