/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.PasswordPolicyType;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class PasswordPolicyTypeJsonUnmarshaller
implements Unmarshaller<PasswordPolicyType, JsonUnmarshallerContext> {
    private static PasswordPolicyTypeJsonUnmarshaller instance;

    PasswordPolicyTypeJsonUnmarshaller() {
    }

    public PasswordPolicyType unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        PasswordPolicyType passwordPolicyType = new PasswordPolicyType();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("MinimumLength")) {
                passwordPolicyType.setMinimumLength(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequireUppercase")) {
                passwordPolicyType.setRequireUppercase(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequireLowercase")) {
                passwordPolicyType.setRequireLowercase(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequireNumbers")) {
                passwordPolicyType.setRequireNumbers(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("RequireSymbols")) {
                passwordPolicyType.setRequireSymbols(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("TemporaryPasswordValidityDays")) {
                passwordPolicyType.setTemporaryPasswordValidityDays(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return passwordPolicyType;
    }

    public static PasswordPolicyTypeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PasswordPolicyTypeJsonUnmarshaller();
        }
        return instance;
    }
}

