/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations;

import android.content.Context;
import android.os.Handler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.CognitoIdentityProviderContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.services.cognitoidentityprovider.model.RespondToAuthChallengeResult;
import java.util.Collections;
import java.util.Map;

public class MultiFactorAuthenticationContinuation
implements CognitoIdentityProviderContinuation<CognitoUserCodeDeliveryDetails> {
    public static final boolean RUN_IN_BACKGROUND = true;
    public static final boolean RUN_IN_CURRENT = false;
    private final CognitoUser user;
    private final Context context;
    private final RespondToAuthChallengeResult challenge;
    private final boolean runInBackground;
    private final AuthenticationHandler callback;
    private String mfaCode = null;
    private Map<String, String> clientMetadata;

    public MultiFactorAuthenticationContinuation(CognitoUser user, Context context, RespondToAuthChallengeResult challenge, boolean runInBackground, AuthenticationHandler callback) {
        this.user = user;
        this.context = context;
        this.callback = callback;
        this.runInBackground = runInBackground;
        this.challenge = challenge;
        this.clientMetadata = Collections.emptyMap();
    }

    public Map<String, String> getClientMetaData() {
        return this.clientMetadata;
    }

    public void setClientMetaData(Map<String, String> clientMetadata) {
        this.clientMetadata.clear();
        this.clientMetadata.putAll(clientMetadata);
    }

    @Override
    public CognitoUserCodeDeliveryDetails getParameters() {
        if ("SOFTWARE_TOKEN_MFA".equals(this.challenge.getChallengeName())) {
            return new CognitoUserCodeDeliveryDetails("Time-based One-time Password", this.challenge.getChallengeParameters().get("FRIENDLY_DEVICE_NAME"), null);
        }
        if ("SMS_MFA".equals(this.challenge.getChallengeName())) {
            return new CognitoUserCodeDeliveryDetails(this.challenge.getChallengeParameters().get("CODE_DELIVERY_DESTINATION"), this.challenge.getChallengeParameters().get("CODE_DELIVERY_DELIVERY_MEDIUM"), null);
        }
        return new CognitoUserCodeDeliveryDetails("", "", "");
    }

    @Override
    public void continueTask() {
        if (this.runInBackground) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Runnable nextStep;
                    Handler handler = new Handler(MultiFactorAuthenticationContinuation.this.context.getMainLooper());
                    try {
                        nextStep = MultiFactorAuthenticationContinuation.this.user.respondToMfaChallenge(MultiFactorAuthenticationContinuation.this.clientMetadata, MultiFactorAuthenticationContinuation.this.mfaCode, MultiFactorAuthenticationContinuation.this.challenge, MultiFactorAuthenticationContinuation.this.callback, true);
                    }
                    catch (Exception e) {
                        nextStep = new Runnable(){

                            @Override
                            public void run() {
                                MultiFactorAuthenticationContinuation.this.callback.onFailure(e);
                            }
                        };
                    }
                    handler.post(nextStep);
                }
            }).start();
        } else {
            Runnable nextStep;
            try {
                nextStep = this.user.respondToMfaChallenge(this.clientMetadata, this.mfaCode, this.challenge, this.callback, false);
            }
            catch (Exception e) {
                nextStep = new Runnable(){

                    @Override
                    public void run() {
                        MultiFactorAuthenticationContinuation.this.callback.onFailure(e);
                    }
                };
            }
            nextStep.run();
        }
    }

    public void setMfaCode(String mfaCode) {
        this.mfaCode = mfaCode;
    }
}

