/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.NumberAttributeConstraintsType;
import com.amazonaws.services.cognitoidentityprovider.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidentityprovider.model.StringAttributeConstraintsType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.NumberAttributeConstraintsTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.StringAttributeConstraintsTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;

class SchemaAttributeTypeJsonMarshaller {
    private static SchemaAttributeTypeJsonMarshaller instance;

    SchemaAttributeTypeJsonMarshaller() {
    }

    public void marshall(SchemaAttributeType schemaAttributeType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (schemaAttributeType.getName() != null) {
            String name = schemaAttributeType.getName();
            jsonWriter.name("Name");
            jsonWriter.value(name);
        }
        if (schemaAttributeType.getAttributeDataType() != null) {
            String attributeDataType = schemaAttributeType.getAttributeDataType();
            jsonWriter.name("AttributeDataType");
            jsonWriter.value(attributeDataType);
        }
        if (schemaAttributeType.getDeveloperOnlyAttribute() != null) {
            Boolean developerOnlyAttribute = schemaAttributeType.getDeveloperOnlyAttribute();
            jsonWriter.name("DeveloperOnlyAttribute");
            jsonWriter.value(developerOnlyAttribute.booleanValue());
        }
        if (schemaAttributeType.getMutable() != null) {
            Boolean mutable = schemaAttributeType.getMutable();
            jsonWriter.name("Mutable");
            jsonWriter.value(mutable.booleanValue());
        }
        if (schemaAttributeType.getRequired() != null) {
            Boolean required = schemaAttributeType.getRequired();
            jsonWriter.name("Required");
            jsonWriter.value(required.booleanValue());
        }
        if (schemaAttributeType.getNumberAttributeConstraints() != null) {
            NumberAttributeConstraintsType numberAttributeConstraints = schemaAttributeType.getNumberAttributeConstraints();
            jsonWriter.name("NumberAttributeConstraints");
            NumberAttributeConstraintsTypeJsonMarshaller.getInstance().marshall(numberAttributeConstraints, jsonWriter);
        }
        if (schemaAttributeType.getStringAttributeConstraints() != null) {
            StringAttributeConstraintsType stringAttributeConstraints = schemaAttributeType.getStringAttributeConstraints();
            jsonWriter.name("StringAttributeConstraints");
            StringAttributeConstraintsTypeJsonMarshaller.getInstance().marshall(stringAttributeConstraints, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static SchemaAttributeTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SchemaAttributeTypeJsonMarshaller();
        }
        return instance;
    }
}

