/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import java.util.Date;

public final class DatasetMetadata {
    private final String datasetName;
    private final Date creationDate;
    private final Date lastModifiedDate;
    private final String lastModifiedBy;
    private final long storageSizeBytes;
    private final long recordCount;

    public String getDatasetName() {
        return this.datasetName;
    }

    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    public Date getLastModifiedDate() {
        return new Date(this.lastModifiedDate.getTime());
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public long getStorageSizeBytes() {
        return this.storageSizeBytes;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    private DatasetMetadata(Builder builder) {
        this.datasetName = builder.datasetName;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.creationDate = builder.creationDate == null ? new Date(0L) : new Date(builder.creationDate.getTime());
        this.lastModifiedDate = builder.lastModifiedDate == null ? new Date() : new Date(builder.lastModifiedDate.getTime());
        this.storageSizeBytes = builder.storageSizeBytes;
        this.recordCount = builder.recordCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dataset_name:[").append(this.datasetName).append("],").append("creation_date:[").append(this.creationDate).append("],").append("last_modified_date:[").append(this.lastModifiedDate).append("],").append("last_modified_by:[").append(this.lastModifiedBy).append("],").append("storage_size_bytes:[").append(this.storageSizeBytes).append("],").append("record_count:[").append(this.recordCount).append("]");
        return sb.toString();
    }

    public static final class Builder {
        private final String datasetName;
        private Date creationDate;
        private Date lastModifiedDate;
        private String lastModifiedBy;
        private long storageSizeBytes;
        private long recordCount;

        public Builder(String datasetName) {
            this.datasetName = datasetName;
        }

        public Builder creationDate(Date creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Builder storageSizeBytes(long storageSizeBytes) {
            if (storageSizeBytes < 0L) {
                throw new IllegalArgumentException("Storage size can't be negative");
            }
            this.storageSizeBytes = storageSizeBytes;
            return this;
        }

        public Builder recordCount(long recordCount) {
            if (recordCount < 0L) {
                throw new IllegalArgumentException("Number of records can't be negative");
            }
            this.recordCount = recordCount;
            return this;
        }

        public DatasetMetadata build() {
            return new DatasetMetadata(this);
        }
    }
}

