/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteDatasetRequestMarshaller
implements Marshaller<Request<DeleteDatasetRequest>, DeleteDatasetRequest> {
    public Request<DeleteDatasetRequest> marshall(DeleteDatasetRequest deleteDatasetRequest) {
        if (deleteDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)deleteDatasetRequest, "AmazonCognitoSync");
        String string = "AWSCognitoSyncService.DeleteDataset";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.DELETE);
        String string2 = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        string2 = string2.replace("{IdentityPoolId}", deleteDatasetRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)deleteDatasetRequest.getIdentityPoolId()));
        string2 = string2.replace("{IdentityId}", deleteDatasetRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)deleteDatasetRequest.getIdentityId()));
        string2 = string2.replace("{DatasetName}", deleteDatasetRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)deleteDatasetRequest.getDatasetName()));
        string2 = string2.replaceAll("//", "/");
        if (string2.contains("?")) {
            String string3 = string2.substring(string2.indexOf("?") + 1);
            string2 = string2.substring(0, string2.indexOf("?"));
            for (String string4 : string3.split("[;&]")) {
                String[] stringArray = string4.split("=");
                if (stringArray.length != 2 || stringArray[1].isEmpty()) continue;
                defaultRequest.addParameter(stringArray[0], stringArray[1]);
            }
        }
        defaultRequest.setResourcePath(string2);
        defaultRequest.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        return defaultRequest;
    }
}

