/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateRecordsRequestMarshaller
implements Marshaller<Request<UpdateRecordsRequest>, UpdateRecordsRequest> {
    public Request<UpdateRecordsRequest> marshall(UpdateRecordsRequest updateRecordsRequest) {
        Object object;
        if (updateRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)updateRecordsRequest, "AmazonCognitoSync");
        String string = "AWSCognitoSyncService.UpdateRecords";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.POST);
        if (updateRecordsRequest.getClientContext() != null) {
            defaultRequest.addHeader("x-amz-Client-Context", StringUtils.fromString((String)updateRecordsRequest.getClientContext()));
        }
        String string2 = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        string2 = string2.replace("{IdentityPoolId}", updateRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityPoolId()));
        string2 = string2.replace("{IdentityId}", updateRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityId()));
        string2 = string2.replace("{DatasetName}", updateRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getDatasetName()));
        if ((string2 = string2.replaceAll("//", "/")).contains("?")) {
            object = string2.substring(string2.indexOf("?") + 1);
            string2 = string2.substring(0, string2.indexOf("?"));
            for (String object22 : ((String)object).split("[;&]")) {
                String[] stringArray = object22.split("=");
                if (stringArray.length != 2 || stringArray[1].isEmpty()) continue;
                defaultRequest.addParameter(stringArray[0], stringArray[1]);
            }
        }
        defaultRequest.setResourcePath(string2);
        try {
            object = new StringWriter();
            String[] stringArray = new JSONWriter((Writer)object);
            stringArray.object();
            ListWithAutoConstructFlag listWithAutoConstructFlag = (ListWithAutoConstructFlag)updateRecordsRequest.getRecordPatches();
            if (!(listWithAutoConstructFlag == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                stringArray.key("RecordPatches");
                stringArray.array();
                for (RecordPatch recordPatch : listWithAutoConstructFlag) {
                    if (recordPatch == null) continue;
                    stringArray.object();
                    if (recordPatch.getOp() != null) {
                        stringArray.key("Op").value((Object)recordPatch.getOp());
                    }
                    if (recordPatch.getKey() != null) {
                        stringArray.key("Key").value((Object)recordPatch.getKey());
                    }
                    if (recordPatch.getValue() != null) {
                        stringArray.key("Value").value((Object)recordPatch.getValue());
                    }
                    if (recordPatch.getSyncCount() != null) {
                        stringArray.key("SyncCount").value((Object)recordPatch.getSyncCount());
                    }
                    if (recordPatch.getDeviceLastModifiedDate() != null) {
                        stringArray.key("DeviceLastModifiedDate").value(recordPatch.getDeviceLastModifiedDate());
                    }
                    stringArray.endObject();
                }
                stringArray.endArray();
            }
            if (updateRecordsRequest.getSyncSessionToken() != null) {
                stringArray.key("SyncSessionToken").value((Object)updateRecordsRequest.getSyncSessionToken());
            }
            stringArray.endObject();
            String string3 = ((StringWriter)object).toString();
            byte[] byArray = string3.getBytes(StringUtils.UTF8);
            defaultRequest.setContent((InputStream)new StringInputStream(string3));
            defaultRequest.addHeader("Content-Length", Integer.toString(byArray.length));
            defaultRequest.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable throwable) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + throwable.getMessage(), throwable);
        }
        return defaultRequest;
    }
}

