/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.util.Log;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.Record;
import com.amazonaws.mobileconnectors.cognito.SyncConflict;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import java.util.ArrayList;
import java.util.List;

public class DefaultSyncCallback
implements Dataset.SyncCallback {
    private static final String TAG = "DefaultSyncCallback";

    @Override
    public void onSuccess(Dataset dataset, List<Record> list) {
        Log.i((String)TAG, (String)String.format("%d records synced successfully.", list.size()));
    }

    @Override
    public boolean onConflict(Dataset dataset, List<SyncConflict> list) {
        Log.i((String)TAG, (String)"onConflict resolved with DefaultSyncCallback's default implementation (last writer wins).");
        ArrayList<Record> arrayList = new ArrayList<Record>(list.size());
        for (SyncConflict syncConflict : list) {
            arrayList.add(syncConflict.resolveWithLastWriterWins());
        }
        dataset.resolve(arrayList);
        return true;
    }

    @Override
    public boolean onDatasetDeleted(Dataset dataset, String string) {
        Log.w((String)TAG, (String)"onDatasetDeleted was called and DefaultSyncCallback doesn't provide an implementation for it");
        return false;
    }

    @Override
    public boolean onDatasetsMerged(Dataset dataset, List<String> list) {
        Log.w((String)TAG, (String)"onDatasetsMerged was called and DefaultSyncCallback doesn't provide an implementation for it");
        return false;
    }

    @Override
    public void onFailure(DataStorageException dataStorageException) {
        Log.e((String)TAG, (String)"Failure occurred during sync", (Throwable)((Object)dataStorageException));
    }
}

