/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.cognito;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.mobileconnectors.cognito.Dataset;
import com.amazonaws.mobileconnectors.cognito.DatasetMetadata;
import com.amazonaws.mobileconnectors.cognito.DefaultDataset;
import com.amazonaws.mobileconnectors.cognito.PushSyncUpdate;
import com.amazonaws.mobileconnectors.cognito.exceptions.DataStorageException;
import com.amazonaws.mobileconnectors.cognito.exceptions.RegistrationFailedException;
import com.amazonaws.mobileconnectors.cognito.exceptions.UnsubscribeFailedException;
import com.amazonaws.mobileconnectors.cognito.internal.storage.CognitoSyncStorage;
import com.amazonaws.mobileconnectors.cognito.internal.storage.SQLiteLocalStorage;
import com.amazonaws.mobileconnectors.cognito.internal.util.DatasetUtils;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.ResourceNotFoundException;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.List;

public class CognitoSyncManager {
    private static final String TAG = "CognitoSyncManager";
    private static final String USER_AGENT = CognitoSyncManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String DATABASE_NAME = "cognito_dataset_cache.db";
    private static SQLiteLocalStorage local;
    private final Context context;
    private final CognitoSyncStorage remote;
    private final CognitoCachingCredentialsProvider provider;
    private final AmazonCognitoSyncClient syncClient;
    private final String identityPoolId;

    @Deprecated
    public CognitoSyncManager(Context context, String string, Regions regions, CognitoCachingCredentialsProvider cognitoCachingCredentialsProvider) {
        this(context, regions, cognitoCachingCredentialsProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CognitoSyncManager(Context context, Regions regions, CognitoCachingCredentialsProvider cognitoCachingCredentialsProvider) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.context = context;
        this.provider = cognitoCachingCredentialsProvider;
        this.identityPoolId = cognitoCachingCredentialsProvider.getIdentityPoolId();
        Class<CognitoSyncManager> clazz = CognitoSyncManager.class;
        synchronized (CognitoSyncManager.class) {
            if (local == null) {
                local = new SQLiteLocalStorage(context, DATABASE_NAME);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.syncClient = new AmazonCognitoSyncClient((AWSCredentialsProvider)cognitoCachingCredentialsProvider);
            this.syncClient.setRegion(Region.getRegion((Regions)regions));
            this.remote = new CognitoSyncStorage(this.identityPoolId, this.syncClient, cognitoCachingCredentialsProvider);
            this.remote.setUserAgent(USER_AGENT);
            cognitoCachingCredentialsProvider.registerIdentityChangedListener(new IdentityChangedListener(){

                public void identityChanged(String string, String string2) {
                    Log.i((String)CognitoSyncManager.TAG, (String)"identity change detected");
                    local.changeIdentityId(string == null ? "unknown" : string, string2 == null ? "unknown" : string2);
                }
            });
            return;
        }
    }

    public Dataset openOrCreateDataset(String string) {
        DatasetUtils.validateDatasetName(string);
        local.createDataset(this.getIdentityId(), string);
        DefaultDataset defaultDataset = new DefaultDataset(this.context, string, this.provider, local, this.remote);
        return defaultDataset;
    }

    public List<DatasetMetadata> listDatasets() {
        return local.getDatasets(this.getIdentityId());
    }

    public void refreshDatasetMetadata() throws DataStorageException {
        List<DatasetMetadata> list = this.remote.getDatasets();
        local.updateDatasetMetadata(this.getIdentityId(), list);
    }

    public void wipeData() {
        this.provider.clear();
        local.wipeData();
        Log.i((String)TAG, (String)"All data has been wiped");
    }

    String getIdentityId() {
        return DatasetUtils.getIdentityId(this.provider);
    }

    public void registerDevice(String string, String string2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        if (this.isDeviceRegistered()) {
            Log.i((String)TAG, (String)"Device is already registered");
            return;
        }
        String string3 = this.provider.getIdentityId();
        RegisterDeviceRequest registerDeviceRequest = new RegisterDeviceRequest().withIdentityPoolId(this.provider.getIdentityPoolId()).withIdentityId(string3).withPlatform(string).withToken(string2);
        try {
            RegisterDeviceResult registerDeviceResult = this.syncClient.registerDevice(registerDeviceRequest);
            String string4 = registerDeviceResult.getDeviceId();
            sharedPreferences.edit().putString("deviceId", string4).putString("platform", string).putString("token", string2).apply();
            Log.i((String)TAG, (String)("Device is registered successfully: " + string4));
        }
        catch (AmazonClientException amazonClientException) {
            Log.e((String)TAG, (String)"Failed to register device", (Throwable)amazonClientException);
            throw new RegistrationFailedException("Failed to register device", amazonClientException);
        }
    }

    public boolean isDeviceRegistered() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        return !sharedPreferences.getString("deviceId", "").isEmpty() && !sharedPreferences.getString("platform", "").isEmpty() && !sharedPreferences.getString("token", "").isEmpty();
    }

    public void unregisterDevice() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        sharedPreferences.edit().remove("deviceId").remove("platform").remove("token").apply();
    }

    public void subscribeAll() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DatasetMetadata datasetMetadata : this.listDatasets()) {
            arrayList.add(datasetMetadata.getDatasetName());
        }
        this.subscribe(arrayList);
    }

    public void subscribe(List<String> list) {
        for (String string : list) {
            Dataset dataset = this.openOrCreateDataset(string);
            dataset.subscribe();
        }
    }

    public void unsubscribeAll() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DatasetMetadata datasetMetadata : this.listDatasets()) {
            arrayList.add(datasetMetadata.getDatasetName());
        }
        this.unsubscribe(arrayList);
    }

    public void unsubscribe(List<String> list) {
        for (String string : list) {
            Dataset dataset = this.openOrCreateDataset(string);
            try {
                dataset.unsubscribe();
            }
            catch (UnsubscribeFailedException unsubscribeFailedException) {
                if (unsubscribeFailedException.getCause() instanceof ResourceNotFoundException) {
                    Log.w((String)TAG, (String)("Unable to unsubscribe to dataset " + string + ", dataset not a subscription"));
                    continue;
                }
                throw unsubscribeFailedException;
            }
        }
    }

    public PushSyncUpdate getPushSyncUpdate(Intent intent) {
        return new PushSyncUpdate(intent);
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences("com.amazonaws.mobileconnectors.cognito", 0);
    }
}

